package #(package).controller.admin;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.miw.gen.utils.BaseController;
import cn.miw.gen.utils.R;

import cn.hutool.json.JSONArray;

import lombok.extern.slf4j.Slf4j;

@Controller
@Slf4j
@RequestMapping("/admin")
public class Index extends BaseController{

	@GetMapping("/")
	public String index() {
		active = "首页";
		return render("/admin/index.html");
	}
	@GetMapping("/login")
	public String login() {
		active = "登录";
		return render("/admin/login.html");
	}
	@GetMapping("/logout")
	public String logout() {
		removeSession("user");
		return "redirect:/admn/";
	}
	@PostMapping("/login")
	@ResponseBody
	public Object login(String u,String p) {
		setSession("user", 1);
		log.info("{}:{}",u,p);
		R res = new R(0, "登录成功");
		return res;
	}
	@GetMapping("/listMenu")
	@ResponseBody
	public Object listMenu() {
		//Object user = getSession("user");
		//左边菜单重构，菜单数据采用数组,主菜单parentId:0
		JSONArray menus = new JSONArray("[\n"
				+ "	{id:1,parentId:0, title:'智慧阅读',url:''}\n"
				+ "   ,{id:2,parentId:5, title:'智慧阅读1',url:'https://www.miw.cn'}\n"
				+ "   ,{id:3,parentId:1, title:'智慧阅读3',url:'https://www.miw.cn'}\n"
				+ "   ,{id:4,parentId:0, title:'智慧阅读4',url:'https://www.miw.cn'}\n"
				+ "   ,{id:5,parentId:4, title:'智慧阅读5',url:'https://www.miw.cn'}\n"
				+ "]");
		return new R(menus);
	}
}
