package #(package)#(business).controller.admin;

import java.util.Arrays;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import #(package)#(business).model.#(entityName);
import #(package)#(business).service.#(entityName)Service;
import cn.miw.gen.utils.BaseController;
import cn.miw.gen.utils.R;

/**
 * #(entityName) 控制器 <br>
 * 基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架 <br>
 * @author mrzhou@miw.cn <br>
 * @date #now('yyyy-MM-dd HH:mm:ss') <br>
 * @see <a href="https://www.miw.cn/">来之里看看</a>
 */
@Controller
//@Slf4j
public class Admin#(entityName) extends BaseController {
	@Autowired private #(entityName)Service service;

	@GetMapping("#(url)")
	public String index(String title) {
		active = title;
		return render("#(url)/list.html");
	}

	@GetMapping("#(url)/edit")
	public String edit(#(getType(pk.type)) id) {
		#(entityName) item = null;
		if (id != null) {
			item = service.getById(id);
		}
		item = item != null ? item : new #(entityName)();
		setAttr("item", item);
		return render("#(url)/edit.html");
	}


	@PostMapping("#(url)/list")
	@ResponseBody
	public Object list(Integer page, Integer limit, String keyword) {
		return new R(service.page(page, limit, keyword));
	}

	@PostMapping("#(url)/save")
	@ResponseBody
	public Object save(@RequestBody #(entityName) item) {
		return new R(service.saveOrUpdate(item));
	}

	@PostMapping("#(url)/del")
	@ResponseBody
	public Object del(@RequestBody #(getType(pk.type))[] ids) {
		if(ids!=null) service.removeBatchByIds(Arrays.asList(ids));
		return new R(ids);
	}
}
