/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.gen.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.miw.gen.utils.SimpleUtil;
import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.ext.directive.NowDirective;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;

public class GenUtil {
    private DataSource ds;

    public GenUtil(DataSource ds) {
        this.ds = ds;
    }

    public void gen(String pkg, String business) {
        List tables = this.ds != null ? MetaUtil.getTables((DataSource)this.ds) : null;
        this.gen(pkg, business, tables);
    }

    public void gen(String pkg, String business, List<String> tables) {
        this.gen(pkg, business, tables, "/src/main/java", "/src/main/resources/templates", false);
    }

    public void gen(String pkg, String business, List<String> tables, String javaPath, String tempPath, boolean override) {
        String[] stringArray;
        JSONObject data = new JSONObject().set("package", (Object)pkg);
        if (StrKit.notBlank((String)business)) {
            stringArray = business.split("\\|");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] cells = stringArray;
        business = cells[0];
        String bizz = cells.length > 1 ? cells[0] : business;
        bizz = SimpleUtil.genName(bizz, 0);
        String businessName = cells.length > 1 ? cells[1] : business;
        data.set("bizz", (Object)bizz).set("businessName", (Object)businessName);
        business = StrUtil.isNotBlank((CharSequence)bizz) && !bizz.startsWith(".") ? "." + SimpleUtil.genName(bizz, 1) : bizz;
        String staticDir = this.processStatic(tempPath);
        HashSet<JSONObject> menus = new HashSet<JSONObject>();
        if (tables != null && this.ds != null) {
            for (String tableName : tables) {
                Table tableMeta = MetaUtil.getTableMeta((DataSource)this.ds, (String)tableName);
                String comment = StrUtil.cleanBlank((CharSequence)tableMeta.getComment());
                comment = StrKit.isBlank((String)comment) ? tableName : comment;
                String entityName = bizz + SimpleUtil.genName(tableName, 0);
                data.set("entityName", (Object)entityName);
                String url = (StrKit.isBlank((String)bizz) ? "" : bizz + "/") + SimpleUtil.genName(tableName, 0);
                url = "/admin/" + url;
                menus.add(new JSONObject().set("id", (Object)(menus.size() + 2)).set("parentId", (Object)1).set("title", (Object)comment).set("url", (Object)url));
                data.set("tableName", (Object)tableName).set("business", (Object)business).set("tableComment", (Object)comment).set("url", (Object)url);
                Set pkNames = tableMeta.getPkNames();
                String pk = CollUtil.isNotEmpty((Collection)pkNames) ? (String)pkNames.stream().findFirst().get() : null;
                Column pkCol = null;
                Collection fields = tableMeta.getColumns();
                pkCol = pk != null ? fields.stream().filter(x -> x.getName().equals(pk)).findFirst().get() : (Column)fields.stream().findFirst().get();
                fields = fields.stream().map(x -> {
                    x.setComment(StrUtil.cleanBlank((CharSequence)x.getComment()));
                    return x;
                }).collect(Collectors.toList());
                data.set("fields", (Object)fields).set("pk", (Object)pkCol.setComment(StrUtil.cleanBlank((CharSequence)pkCol.getComment())));
                String path = this.buildDir(javaPath, pkg, business, "model");
                String target = path + File.separator + bizz + SimpleUtil.genName(tableName, 0) + ".java";
                this.create("/tpl/java/model.tpl", data, target, override);
                path = this.buildDir(javaPath, pkg, business, "mapper");
                target = path + File.separator + bizz + SimpleUtil.genName(tableName, 0) + "Mapper.java";
                this.create("/tpl/java/Mapper.tpl", data, target, override);
                path = this.buildDir(javaPath, pkg, business, "service");
                target = path + File.separator + bizz + SimpleUtil.genName(tableName, 0) + "Service.java";
                this.create("/tpl/java/Service.tpl", data, target, override);
                path = this.buildDir(javaPath, pkg, business, "service.impl");
                target = path + File.separator + bizz + SimpleUtil.genName(tableName, 0) + "ServiceImpl.java";
                this.create("/tpl/java/Impl.tpl", data, target, override);
                path = this.buildDir(javaPath, pkg, business, "controller.admin");
                target = path + File.separator + "Admin" + bizz + SimpleUtil.genName(tableName, 0) + ".java";
                this.create("/tpl/java/controller.tpl", data, target, override);
                path = this.buildDir(tempPath, "/admin", business, bizz + SimpleUtil.genName(tableName, 0));
                target = path + File.separator + "list.html";
                this.create("/tpl/list.tpl", data, target, override);
                target = path + File.separator + "edit.html";
                this.create("/tpl/edit.tpl", data, target, override);
            }
        }
        String bussMenuName = StrKit.isBlank((String)businessName) ? "\u7cfb\u7edf\u4e1a\u52a1" : businessName;
        this.processMenu(staticDir, bussMenuName, menus);
        this.processConfig(pkg, javaPath);
        this.processDefault(tempPath);
        this.processPOM(javaPath);
    }

    private void create(String tpl, JSONObject data, String target, boolean override) {
        File file = new File(target);
        if (!file.exists() || file.exists() && override) {
            this.genFile(tpl, (Map<?, ?>)data, file);
        }
    }

    private void processMenu(String staticDir, String buess, Set<JSONObject> menus) {
        String path = staticDir + File.separator + "json/menu.json";
        File menuFile = new File(path);
        JSONArray oldMenu = menuFile.exists() ? JSONUtil.readJSONArray((File)menuFile, (Charset)Charset.forName("utf-8")) : new JSONArray();
        oldMenu.add((Object)new JSONObject().set("id", (Object)1).set("parentId", (Object)0).set("title", (Object)buess));
        oldMenu.addAll(menus);
        FileUtil.writeUtf8String((String)oldMenu.toJSONString(0), (File)menuFile);
    }

    private void processPOM(String javaPath) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processStatic(String tempPath) {
        File parent = new File(new File("").getAbsolutePath() + tempPath).getParentFile();
        try (ZipInputStream zipInputStream = new ZipInputStream(ResourceUtil.getStream((String)"static.zip"));){
            File unzip = ZipUtil.unzip((ZipInputStream)zipInputStream, (File)parent);
            String string = unzip.getAbsolutePath() + File.separator + "static";
            return string;
        }
        catch (NoResourceException | IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void processDefault(String tempPath) {
        JSONObject data = new JSONObject();
        String path = this.buildDir(tempPath, "/admin", "", "");
        String target = path + File.separator + "_temp.html";
        File file = new File(target);
        if (!file.exists()) {
            this.genFile("/tpl/default/_temp.html.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "index.html")).exists()) {
            this.genFile("/tpl/default/index.html.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "welcome.html")).exists()) {
            this.genFile("/tpl/default/welcome.html.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "login.html")).exists()) {
            this.genFile("/tpl/default/login.html.tpl", (Map<?, ?>)data, file);
        }
    }

    private void processConfig(String pkg, String javaPath) {
        JSONObject data = new JSONObject().set("package", (Object)pkg);
        String path = this.buildDir(javaPath, pkg, "", "controller.admin");
        String target = path + File.separator + "Index.java";
        File file = new File(target);
        if (!file.exists()) {
            this.genFile("/tpl/config/Index.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, "", "inter")) + File.separator + "AdminInter.java")).exists()) {
            this.genFile("/tpl/config/AdminInter.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, "", "config")) + File.separator + "MybatisPlusConfig.java")).exists()) {
            this.genFile("/tpl/config/MybatisPlusConfig.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "ViewConfig.java")).exists()) {
            this.genFile("/tpl/config/ViewConfig.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "AppConfig.java")).exists()) {
            this.genFile("/tpl/config/AppConfig.java.tpl", (Map<?, ?>)data, file);
        }
    }

    private String buildDir(String where, String pkg, String business, String t) {
        String x = where + File.separator + (StrUtil.isEmptyIfStr((Object)pkg) ? "" : pkg + File.separator) + (StrUtil.isEmptyIfStr((Object)business) ? "" : business + File.separator) + t;
        String path = new File("").getAbsolutePath() + x.replace(".", File.separator);
        File file = new File(path);
        if (!file.exists() || file.isFile()) {
            file.mkdirs();
        }
        return path;
    }

    private void genFile(String tpl, Map<?, ?> data, File target) {
        Engine engine = Engine.use((String)"genUtil");
        if (engine == null) {
            engine = Engine.create((String)"genUtil");
            engine.setDevMode(true).setToClassPathSourceFactory();
            engine.addSharedMethod((Object)new StrUtil());
            engine.addSharedMethod((Object)new StrKit());
            engine.addSharedMethod((Object)new CollUtil());
            engine.addSharedMethod((Object)new SimpleUtil());
            engine.addDirective("now", NowDirective.class);
        }
        Template temp = engine.getTemplate(tpl);
        System.out.println(target.getAbsolutePath());
        temp.render(data, target);
    }
}

