package #(package).inter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import lombok.extern.slf4j.Slf4j;
@Component
@Slf4j
public class AdminInter implements HandlerInterceptor{


	@Autowired private HttpSession session;

	@Override
	public boolean preHandle(HttpServletRequest req, HttpServletResponse resp, Object handler) throws Exception {
		String uri = req.getRequestURI();
		log.info("权限检测1:{}",uri);

		Object user = session.getAttribute("user");
		if(user!=null && uri.equals("/admin/listMenu")) return true;
		log.info("权限检测2:{}",uri);
		boolean isAdmin = user!=null && uri.startsWith("/admin");
		if(!isAdmin) {
			resp.sendRedirect("/admin/login/");
			return false;
		}
		session.setAttribute("isAdmin", isAdmin);
		return isAdmin;
	}

}
