package #(package).config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import com.fasterxml.jackson.databind.ObjectMapper;

import cn.miw.gen.utils.SimpleUtil;
import cn.miw.gentest.inter.AdminInter;

@Configuration
public class AppConfig implements WebMvcConfigurer {

	@Autowired
	private AdminInter adminInter;

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry o) {
		o.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
	}

	@Override
	public void addInterceptors(InterceptorRegistry o) {
		String[] exStaticPaths = {	"/error", "/static/**", "/favicon.ico", "/MP**", //
									"/uploadFile", //
									"/wx/getConfig", "/post", "/receiveWx" };
		o.addInterceptor(adminInter).addPathPatterns("/admin/**").excludePathPatterns("/admin/login/**", "/admin/logout").excludePathPatterns(exStaticPaths);

	}

	@Bean
	public ObjectMapper objectMapper() {
		return SimpleUtil.objectMapper();
	}

}
