package cn.miw.mybatisGen.util;

import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbsctactGenerator {

	/**
	 * 返回需要生成的表
	 * 
	 * @return
	 * @throws SQLException
	 */
	protected abstract List<TableInfo> getTables() throws SQLException;

	/**
	 * 返回表中的所有字段
	 * 
	 * @param tableName
	 * @return
	 * @throws SQLException
	 */
	protected abstract List<FieldInfo> getFields(String tableName) throws SQLException;

	private static String getCallerPkg() {
		String targetDir = "";
		StackTraceElement[] stack = (new Throwable()).getStackTrace();
		for (int i = 0; i < stack.length; i++) {
			StackTraceElement ste = stack[i];
			if (!ste.getClassName().equals(AbsctactGenerator.class.getName())) {
				try {
					String name = Class.forName(ste.getClassName()).getPackage().getName();
					targetDir = name;
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				}
			}
		}
		return targetDir;
	}

	/**
	 * 生成到指定文件夹,默认为生成在调用者包下
	 * 
	 * @param sourceDir
	 */
	public void start(String sourceDir) {
		start(sourceDir, getCallerPkg());
	}

	/**
	 * 在指定文件夹中生成相应包下
	 * 
	 * @param sourceDir
	 * @param pkgName
	 */
	public void start(String sourceDir, String pkgName) {
		start(sourceDir, pkgName, "model", "mapper");
	}
	/**
	 * 在指定文件夹中生成相应包下，并指定model和mapper包
	 * @param sourceDir
	 * @param pkgName
	 * @param model
	 * @param mapper
	 */
	public void start(String sourceDir, String pkgName, String model, String mapper) {
		System.err.println(sourceDir);
		System.err.println(pkgName);
		if (sourceDir == null || "".equals(sourceDir.trim())) {
			System.err.println("源文件目录不能为空");
			return;
		}
		System.out.print(".");
		try {
			List<TableInfo> tables = getTables();
			if (tables == null) {
				System.err.println("没有需要处理的表");
				return;
			}
			System.out.print(".");
			genFiles(tables, sourceDir, pkgName, model, mapper);
			System.out.print(".");
		} catch (SQLException | IOException e) {
			e.printStackTrace();
		}
		StringBuffer buffer = new StringBuffer();
		buffer.append("\n=================完成了=================================");
		buffer.append("\n本工具创建的实体与Mapper基于MyBatis-Plus，请自觉引入。");
		buffer.append("\n<dependency>");
		buffer.append("\n    <groupId>com.baomidou</groupId>");
		buffer.append("\n    <artifactId>mybatis-plus-boot-starter</artifactId>");
		buffer.append("\n    <version>3.1.0</version>");
		buffer.append("\n</dependency>");
		buffer.append("\n或者:");
		buffer.append("\n<dependency>");
		buffer.append("\n    <groupId>com.baomidou</groupId>");
		buffer.append("\n    <artifactId>mybatis-plus</artifactId>");
		buffer.append("\n    <version>3.1.0</version>");
		buffer.append("\n</dependency>");
		buffer.append("\n同时还使用了lombok，也请自觉引入。");
		buffer.append("\n<dependency>");
		buffer.append("\n    <groupId>org.projectlombok</groupId>");
		buffer.append("\n    <artifactId>lombok</artifactId>");
		buffer.append("\n    <optional>true</optional>");
		buffer.append("\n    <version>1.18.6</version>");
		buffer.append("\n</dependency>");
		buffer.append("\n========================mrzhou@miw.cn====2019-04-02===\n");
		System.err.println(buffer.toString());
	}
	/**
	 * 实体表信息
	 * @author mrzhou
	 *
	 */
	public class TableInfo {
		public String entityName, orinName, desc;
		public List<FieldInfo> fields;
	}

	private void genFiles(List<TableInfo> tables, String sourceDir, String pkgName, String model, String mapper) throws IOException {
		String path = new java.io.File("").getCanonicalPath();
		String where = path + sourceDir + pkgName.replaceAll("\\.", "/");
		String modelPath = where + "/" + model;
		String mapperPath = where + "/" + mapper;
		createDir(modelPath);
		createDir(mapperPath);
		tables.forEach((table) -> {
			try {
				System.out.print(".");
				writeModelFile(modelPath, pkgName, model, table);
				System.out.print(".");
				writeMapperFile(mapperPath, pkgName, model, mapper, table);
				System.out.print(".");
			} catch (IOException e) {
			}
		});
	}

	private void writeMapperFile(String where, String pkgName, String model, String mapper, TableInfo table) throws IOException {
		java.io.File file = new java.io.File(where + "/" + table.entityName + "Mapper.java");
		if (file.exists()) {
			file.delete();
		}
		FileWriter writer = new FileWriter(file);
		StringBuffer buffer = new StringBuffer();
		buffer.append("package " + pkgName + "." + mapper + ";\n\n");
		buffer.append("import com.baomidou.mybatisplus.core.mapper.BaseMapper;\n");
		buffer.append("import " + pkgName + "." + model + "." + table.entityName + ";\n\n");
		writeAuthor(buffer, table.desc + " Mapper");
		buffer.append("public interface " + table.entityName + "Mapper extends BaseMapper<" + table.entityName + "> {\n\n");
		buffer.append("}\n");
		writer.write(buffer.toString());
		writer.flush();
		writer.close();
	}

	private void writeAuthor(StringBuffer buffer, String name) throws IOException {
		buffer.append("/**\n");
		buffer.append("* " + name + "\n*\n");
		buffer.append("* 生成器创建 by mrzhou@miw.cn\n");
		buffer.append("* @date " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()) + "\n");
		buffer.append("*/\n");
	}

	private void writeModelFile(String where, String pkgName, String model, TableInfo table) throws IOException {
		java.io.File file = new java.io.File(where + "/" + table.entityName + ".java");
		if (file.exists()) {
			file.delete();
		}
		FileWriter writer = new FileWriter(file);
		StringBuffer buffer = new StringBuffer();
		buffer.append("package " + pkgName + "." + model + ";\n\n");
		buffer.append("import java.io.Serializable;\n\n");
		buffer.append("import com.baomidou.mybatisplus.annotation.TableField;\n");
		buffer.append("import com.baomidou.mybatisplus.annotation.TableId;\n");
		buffer.append("import com.baomidou.mybatisplus.annotation.TableName;\n\n");
		buffer.append("import lombok.Data;\n\n");
		writeAuthor(buffer, table.desc + " 实体");
		buffer.append("@Data\n");
		buffer.append("@TableName(\"" + table.orinName + "\")\n");
		buffer.append("public class " + table.entityName + " implements Serializable{\n");
		long rnd = ThreadLocalRandom.current().nextLong();
		buffer.append("\tprivate static final long serialVersionUID = " + rnd + "l;\n");
		if (table.fields != null) {
			try {
				table.fields = getFields(table.orinName);
			} catch (SQLException e) {
			}
		}
		if (table.fields != null) {
			table.fields.forEach((field) -> {
				if (field.isKey) {
					buffer.append("\t@TableId\n");
				}
				buffer.append("\t@TableField(\"" + field.orinName + "\")\n");
				String desc = "";
				if ((null != field.desc && !"".equals(field.desc.trim()))) {
					desc = "\t//" + field.desc;
				}
				buffer.append("\t" + field.clazz.getName() + "\t" + processFieldName(field.name) + ";" + desc + "\n");
			});
		} else {
			System.err.println(table.orinName +" 没有字段");
		}
		buffer.append("}");
		writer.write(buffer.toString());
		writer.flush();
		writer.close();
	}

	private void createDir(String path) {
		java.io.File file = new java.io.File(path);
		if (!file.exists()) {
			file.mkdirs();
		}
	}
	/**
	 * 结字段进行必要的处理
	 * @param fieldName
	 * @param type
	 * @param key
	 * @param comment
	 * @return
	 */
	protected FieldInfo processField(String fieldName, String type, String key, String comment) {
		FieldInfo fieldInfo = new FieldInfo();
		fieldInfo.clazz = getFieldType(type);
		fieldInfo.desc = comment;
		fieldInfo.isKey = "PRI".equals(key);
		fieldInfo.name = processFieldName(fieldName);
		fieldInfo.orinName = fieldName;
		return fieldInfo;
	}

	private String processFieldName(String fieldName) {
		String[] split = fieldName.split("_");
		if (split.length > 1) {
			fieldName = "";
			for (int i = 0; i < split.length; i++) {
				fieldName += (i == 0) ? toLowCap(split[i]) : toUpCap(split[i]);
			}
		}
		return toLowCap(fieldName);
	}
	/**
	 * 对表名进行适当处理
	 * @param tableName
	 * @return
	 */
	protected String processTableName(String tableName) {
		String[] split = tableName.split("_");
		if (split.length > 1) {
			tableName = "";
			for (int i = 0; i < split.length; i++) {
				tableName += toUpCap(split[i]);
			}
		}
		return toUpCap(tableName);
	}

	private String toLowCap(String fieldName) {
		byte[] bytes = fieldName.getBytes();
		bytes[0] += (bytes[0] < 97) ? 32 : 0;
		return new String(bytes);
	}

	private String toUpCap(String fieldName) {
		byte[] bytes = fieldName.getBytes();
		bytes[0] -= (bytes[0] > 96) ? 32 : 0;
		return new String(bytes);
	}
	/**
	 * 获取数据库字段对应的java类型，暂时只处理了一部分常用类型，其他诸位可以复写扩展
	 * @param type
	 * @return
	 */
	protected Class<?> getFieldType(String type) {
		Class<?> clazz = String.class;
		type = type.toLowerCase();
		if (type.contains("int") || type.contains("bit") || type.contains("bool")) {
			clazz = Integer.class;
		} else if (type.contains("datetime") || type.contains("date") || type.contains("year")) {
			clazz = Date.class;
		} else if (type.contains("time")) {
			clazz = Time.class;
		} else if (type.contains("float")) {
			clazz = Float.class;
		} else if (type.contains("decimal")) {
			clazz = BigDecimal.class;
		} else if (type.contains("double")) {
			clazz = Double.class;
		} else if (type.contains("blob")) {
			clazz = byte[].class;
		}
		return clazz;
	}
	/**
	 * 字段信息
	 * @author mrzhou
	 *
	 */
	public class FieldInfo {
		public String name, orinName;
		public Class<?> clazz;
		public boolean isKey = false;
		public String desc;
	}
}
