package cn.miw.mybatisGen.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

public class MysqlGenerator extends AbsctactGenerator {
	private DataSource dataSource;
	public MysqlGenerator(DataSource dataSource){
		this.dataSource = dataSource;
	}

	@Override
	protected List<TableInfo> getTables() throws SQLException {
		List<TableInfo> tables = new ArrayList<>();
		Connection connection = dataSource.getConnection();
		PreparedStatement statement = connection.prepareStatement("show table status");
		ResultSet rs = statement.executeQuery();
		while (rs.next()) {
			String tableName = rs.getString("name");
			String comment = rs.getString("comment");
			//System.err.println(tableName + "\t" + comment);
			TableInfo table = new TableInfo();
			table.entityName = processTableName(tableName);
			table.orinName = tableName;
			table.fields = getFields(tableName);
			table.desc = comment;
			tables.add(table);
		}
		statement.close();
		connection.close();
		statement = null;
		connection = null;
		return tables;
	}

	@Override
	protected List<FieldInfo> getFields(String tableName) throws SQLException {
		Connection connection = dataSource.getConnection();
		PreparedStatement statement = connection.prepareStatement("show full fields from " + tableName);
		List<FieldInfo> fields = new ArrayList<FieldInfo>();
		ResultSet rs = statement.executeQuery();
		while (rs.next()) {
			String fieldName = rs.getString("field");
			String type = rs.getString("type");
			String comment = rs.getString("comment");
			String key = rs.getString("key");
			fields.add(processField(fieldName, type, key, comment));
		}
		statement.close();
		connection.close();
		statement = null;
		connection = null;
		return fields;
	}

	
}
