/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.mybatisGen.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbsctactGenerator {
    protected abstract List<TableInfo> getTables() throws SQLException;

    protected abstract List<FieldInfo> getFields(String var1) throws SQLException;

    private static String getCallerPkg() {
        String targetDir = "";
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            if (ste.getClassName().equals(AbsctactGenerator.class.getName())) continue;
            try {
                String name;
                targetDir = name = Class.forName(ste.getClassName()).getPackage().getName();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return targetDir;
    }

    public void start(String sourceDir) {
        this.start(sourceDir, AbsctactGenerator.getCallerPkg());
    }

    public void start(String sourceDir, String pkgName) {
        this.start(sourceDir, pkgName, "model", "mapper");
    }

    public void start(String sourceDir, String pkgName, String model, String mapper) {
        System.err.println(sourceDir);
        System.err.println(pkgName);
        if (sourceDir == null || "".equals(sourceDir.trim())) {
            System.err.println("\u6e90\u6587\u4ef6\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        System.out.print(".");
        try {
            List<TableInfo> tables = this.getTables();
            if (tables == null) {
                System.err.println("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u8868");
                return;
            }
            System.out.print(".");
            this.genFiles(tables, sourceDir, pkgName, model, mapper);
            System.out.print(".");
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n=================\u5b8c\u6210\u4e86=================================");
        buffer.append("\n\u672c\u5de5\u5177\u521b\u5efa\u7684\u5b9e\u4f53\u4e0eMapper\u57fa\u4e8eMyBatis-Plus\uff0c\u8bf7\u81ea\u89c9\u5f15\u5165\u3002");
        buffer.append("\n<dependency>");
        buffer.append("\n    <groupId>com.baomidou</groupId>");
        buffer.append("\n    <artifactId>mybatis-plus-boot-starter</artifactId>");
        buffer.append("\n    <version>3.1.0</version>");
        buffer.append("\n</dependency>");
        buffer.append("\n\u6216\u8005:");
        buffer.append("\n<dependency>");
        buffer.append("\n    <groupId>com.baomidou</groupId>");
        buffer.append("\n    <artifactId>mybatis-plus</artifactId>");
        buffer.append("\n    <version>3.1.0</version>");
        buffer.append("\n</dependency>");
        buffer.append("\n\u540c\u65f6\u8fd8\u4f7f\u7528\u4e86lombok\uff0c\u4e5f\u8bf7\u81ea\u89c9\u5f15\u5165\u3002");
        buffer.append("\n<dependency>");
        buffer.append("\n    <groupId>org.projectlombok</groupId>");
        buffer.append("\n    <artifactId>lombok</artifactId>");
        buffer.append("\n    <optional>true</optional>");
        buffer.append("\n    <version>1.18.6</version>");
        buffer.append("\n</dependency>");
        buffer.append("\n========================mrzhou@miw.cn====2019-04-02===\n");
        System.err.println(buffer.toString());
    }

    private void genFiles(List<TableInfo> tables, String sourceDir, String pkgName, String model, String mapper) throws IOException {
        String path = new File("").getCanonicalPath();
        String where = path + sourceDir + pkgName.replaceAll("\\.", "/");
        String modelPath = where + "/" + model;
        String mapperPath = where + "/" + mapper;
        this.createDir(modelPath);
        this.createDir(mapperPath);
        tables.forEach(table -> {
            try {
                System.out.print(".");
                this.writeModelFile(modelPath, pkgName, model, (TableInfo)table);
                System.out.print(".");
                this.writeMapperFile(mapperPath, pkgName, model, mapper, (TableInfo)table);
                System.out.print(".");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void writeMapperFile(String where, String pkgName, String model, String mapper, TableInfo table) throws IOException {
        File file = new File(where + "/" + table.entityName + "Mapper.java");
        if (file.exists()) {
            file.delete();
        }
        FileWriter writer = new FileWriter(file);
        StringBuffer buffer = new StringBuffer();
        buffer.append("package " + pkgName + "." + mapper + ";\n\n");
        buffer.append("import com.baomidou.mybatisplus.core.mapper.BaseMapper;\n");
        buffer.append("import " + pkgName + "." + model + "." + table.entityName + ";\n\n");
        this.writeAuthor(buffer, table.desc + " Mapper");
        buffer.append("public interface " + table.entityName + "Mapper extends BaseMapper<" + table.entityName + "> {\n\n");
        buffer.append("}\n");
        writer.write(buffer.toString());
        writer.flush();
        writer.close();
    }

    private void writeAuthor(StringBuffer buffer, String name) throws IOException {
        buffer.append("/**\n");
        buffer.append("* " + name + "\n*\n");
        buffer.append("* \u751f\u6210\u5668\u521b\u5efa by mrzhou@miw.cn\n");
        buffer.append("* @date " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()) + "\n");
        buffer.append("*/\n");
    }

    private void writeModelFile(String where, String pkgName, String model, TableInfo table) throws IOException {
        File file = new File(where + "/" + table.entityName + ".java");
        if (file.exists()) {
            file.delete();
        }
        FileWriter writer = new FileWriter(file);
        StringBuffer buffer = new StringBuffer();
        buffer.append("package " + pkgName + "." + model + ";\n\n");
        buffer.append("import java.io.Serializable;\n\n");
        buffer.append("import com.baomidou.mybatisplus.annotation.TableField;\n");
        buffer.append("import com.baomidou.mybatisplus.annotation.TableId;\n");
        buffer.append("import com.baomidou.mybatisplus.annotation.TableName;\n\n");
        buffer.append("import lombok.Data;\n\n");
        this.writeAuthor(buffer, table.desc + " \u5b9e\u4f53");
        buffer.append("@Data\n");
        buffer.append("@TableName(\"" + table.orinName + "\")\n");
        buffer.append("public class " + table.entityName + " implements Serializable{\n");
        long rnd = ThreadLocalRandom.current().nextLong();
        buffer.append("\tprivate static final long serialVersionUID = " + rnd + "l;\n");
        if (table.fields != null) {
            try {
                table.fields = this.getFields(table.orinName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (table.fields != null) {
            table.fields.forEach(field -> {
                if (field.isKey) {
                    buffer.append("\t@TableId\n");
                }
                buffer.append("\t@TableField(\"" + field.orinName + "\")\n");
                String desc = "";
                if (null != field.desc && !"".equals(field.desc.trim())) {
                    desc = "\t//" + field.desc;
                }
                buffer.append("\t" + field.clazz.getName() + "\t" + this.processFieldName(field.name) + ";" + desc + "\n");
            });
        } else {
            System.err.println(table.orinName + " \u6ca1\u6709\u5b57\u6bb5");
        }
        buffer.append("}");
        writer.write(buffer.toString());
        writer.flush();
        writer.close();
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected FieldInfo processField(String fieldName, String type, String key, String comment) {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.clazz = this.getFieldType(type);
        fieldInfo.desc = comment;
        fieldInfo.isKey = "PRI".equals(key);
        fieldInfo.name = this.processFieldName(fieldName);
        fieldInfo.orinName = fieldName;
        return fieldInfo;
    }

    private String processFieldName(String fieldName) {
        String[] split = fieldName.split("_");
        if (split.length > 1) {
            fieldName = "";
            for (int i = 0; i < split.length; ++i) {
                fieldName = fieldName + (i == 0 ? this.toLowCap(split[i]) : this.toUpCap(split[i]));
            }
        }
        return this.toLowCap(fieldName);
    }

    protected String processTableName(String tableName) {
        String[] split = tableName.split("_");
        if (split.length > 1) {
            tableName = "";
            for (int i = 0; i < split.length; ++i) {
                tableName = tableName + this.toUpCap(split[i]);
            }
        }
        return this.toUpCap(tableName);
    }

    private String toLowCap(String fieldName) {
        byte[] bytes = fieldName.getBytes();
        bytes[0] = (byte)(bytes[0] + (bytes[0] < 97 ? 32 : 0));
        return new String(bytes);
    }

    private String toUpCap(String fieldName) {
        byte[] bytes = fieldName.getBytes();
        bytes[0] = (byte)(bytes[0] - (bytes[0] > 96 ? 32 : 0));
        return new String(bytes);
    }

    protected Class<?> getFieldType(String type) {
        Class clazz = String.class;
        if ((type = type.toLowerCase()).contains("int") || type.contains("bit") || type.contains("bool")) {
            clazz = Integer.class;
        } else if (type.contains("datetime") || type.contains("date") || type.contains("year")) {
            clazz = Date.class;
        } else if (type.contains("time")) {
            clazz = Time.class;
        } else if (type.contains("float")) {
            clazz = Float.class;
        } else if (type.contains("decimal")) {
            clazz = BigDecimal.class;
        } else if (type.contains("double")) {
            clazz = Double.class;
        } else if (type.contains("blob")) {
            clazz = byte[].class;
        }
        return clazz;
    }

    public class FieldInfo {
        public String name;
        public String orinName;
        public Class<?> clazz;
        public boolean isKey = false;
        public String desc;
    }

    public class TableInfo {
        public String entityName;
        public String orinName;
        public String desc;
        public List<FieldInfo> fields;
    }
}

