/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.mybatisGen.util;

import cn.miw.mybatisGen.util.AbsctactGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class MysqlGenerator
extends AbsctactGenerator {
    private DataSource dataSource;

    public MysqlGenerator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    protected List<AbsctactGenerator.TableInfo> getTables() throws SQLException {
        ArrayList<AbsctactGenerator.TableInfo> tables = new ArrayList<AbsctactGenerator.TableInfo>();
        Connection connection = this.dataSource.getConnection();
        PreparedStatement statement = connection.prepareStatement("show table status");
        ResultSet rs = statement.executeQuery();
        while (rs.next()) {
            String tableName = rs.getString("name");
            String comment = rs.getString("comment");
            AbsctactGenerator.TableInfo table = new AbsctactGenerator.TableInfo(this);
            table.entityName = this.processTableName(tableName);
            table.orinName = tableName;
            table.fields = this.getFields(tableName);
            table.desc = comment;
            tables.add(table);
        }
        statement.close();
        connection.close();
        statement = null;
        connection = null;
        return tables;
    }

    @Override
    protected List<AbsctactGenerator.FieldInfo> getFields(String tableName) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        PreparedStatement statement = connection.prepareStatement("show full fields from " + tableName);
        ArrayList<AbsctactGenerator.FieldInfo> fields = new ArrayList<AbsctactGenerator.FieldInfo>();
        ResultSet rs = statement.executeQuery();
        while (rs.next()) {
            String fieldName = rs.getString("field");
            String type = rs.getString("type");
            String comment = rs.getString("comment");
            String key = rs.getString("key");
            fields.add(this.processField(fieldName, type, key, comment));
        }
        statement.close();
        connection.close();
        statement = null;
        connection = null;
        return fields;
    }
}

