/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.spider.utils;

import cn.miw.spider.utils.Client;
import cn.miw.spider.utils.ICatTask;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CatHTML
implements ICatTask {
    private Object flag = "\u667a\u8054\u62db\u8058";
    private long page = 0L;
    private long fin = 1L;
    private int step = 100;
    private int delay = 5000;
    private String url = "https://www.zhaopin.com/citymap?x={{page}}";
    private String listSelector = ".cities-show_lists li";
    private AttDef[] attrs = new AttDef[]{new AttDef("a", "href", false, "href"), new AttDef("", "", true, "city")};
    private boolean enabelJS = false;
    private long count = 0L;

    public CatHTML enaleJS() {
        this.enabelJS = true;
        return this;
    }

    public CatHTML(Object flag, long page, long fin, int step, int delay, String url, String listSelector, AttDef[] attrs) {
        this.flag = flag;
        this.page = page;
        this.fin = fin;
        this.step = step;
        this.delay = delay;
        this.url = url;
        this.listSelector = listSelector;
        this.attrs = attrs;
    }

    @Override
    public void start(final ICatTask.ICatCallBack callBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        String thisUrl = CatHTML.this.url.replace("{{page}}", CatHTML.this.page + "");
                        CatHTML.this.catAPage(thisUrl, callBack);
                        CatHTML.this.page = CatHTML.this.page + (long)CatHTML.this.step;
                        Thread.sleep(CatHTML.this.delay);
                    } while (CatHTML.this.page < CatHTML.this.fin);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (callBack != null) {
                    callBack.catFin(CatHTML.this.flag, CatHTML.this.page, CatHTML.this.count);
                }
            }
        }).start();
    }

    protected void catAPage(String url, ICatTask.ICatCallBack callBack) throws IOException {
        Document doc = this.enabelJS ? Client.getDocument(url) : Client.JSoupGetDocument(url);
        doc = this.PreProcess(doc);
        Elements list = doc.select(this.listSelector);
        JSONArray result = new JSONArray();
        for (Element item : list) {
            JSONObject o = new JSONObject();
            for (AttDef def : this.attrs) {
                String v;
                if (def.selector != null && def.selector.trim().length() > 0) {
                    Element x = item.select(def.selector).first();
                    v = x != null ? (def.isText || def.attrName == null || def.attrName.trim().length() == 0 ? x.text() : x.attr(def.attrName)) : null;
                } else {
                    String string = v = def.isText || def.attrName == null || def.attrName.trim().length() == 0 ? item.text() : item.attr(def.attrName);
                }
                if (v == null) continue;
                o.put(def.target, (Object)v);
            }
            if (o.size() <= 0) continue;
            ++this.count;
            result.add((Object)o);
        }
        if (callBack != null) {
            callBack.catAPage(this.flag, this.page, result);
        }
    }

    public static class AttDef {
        String selector;
        String attrName;
        String target;
        boolean isText;

        public AttDef(String selector, String attrName, boolean isText, String target) {
            this.selector = selector;
            this.attrName = attrName;
            this.target = target;
            this.isText = isText;
        }
    }
}

