/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.spider.utils;

import cn.miw.spider.utils.Client;
import cn.miw.spider.utils.ICatTask;
import cn.miw.spider.utils.JSONKit;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import org.jsoup.nodes.Document;

public class CatJSONP
implements ICatTask {
    private Object flag = "\u667a\u8054\u62db\u8058";
    private long page = 0L;
    private long fin = 40000L;
    private int step = 100;
    private int delay = 5000;
    private String url = "https://fe-api.zhaopin.com/c/i/sou?pageSize=100&cityId=831&workExperience=-1&education=-1&companyType=-1&employmentType=-1&jobWelfareTag=-1&kt=3&start={{page}}";
    private String listSelector = "data.results";
    private String attrs = null;
    private int prefix = 0;
    private int endfix = 0;
    private long count = 0L;
    private long pages = 0L;

    public CatJSONP(Object flag, long page, long fin, int step, int delay, String url, String listSelector, String attrs, String prefix, String endfix) {
        this.flag = flag;
        this.page = page;
        this.fin = fin;
        this.step = step;
        this.delay = delay;
        this.url = url;
        this.listSelector = listSelector;
        this.attrs = attrs;
        this.prefix = prefix.length();
        this.endfix = endfix.length();
    }

    public CatJSONP(Object flag, long page, long fin, int step, int delay, String url, String listSelector, String attrs, int prefixLength, int endfixLength) {
        this.flag = flag;
        this.page = page;
        this.fin = fin;
        this.step = step;
        this.delay = delay;
        this.url = url;
        this.listSelector = listSelector;
        this.attrs = attrs;
        this.prefix = prefixLength;
        this.endfix = endfixLength;
    }

    @Override
    public void start(ICatTask.ICatCallBack callBack) {
        this.catPage(this.flag, this.url, this.page, this.step, this.fin, this.listSelector, this.attrs, this.delay, callBack);
    }

    private void catPage(final Object flag, final String sourceUrl, final long startPage, final long step, final long fin, final String listSelector, final String attrs, final int delay, final ICatTask.ICatCallBack callBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                long page = startPage;
                do {
                    String url = sourceUrl.replace("{{page}}", page + "");
                    try {
                        Document doc = Client.JSoupGetDocument(url);
                        System.out.println(doc.text());
                        String x = doc.text();
                        if (x != null && x.length() > CatJSONP.this.prefix) {
                            x = x.substring(CatJSONP.this.prefix, x.length() - CatJSONP.this.endfix);
                            x = CatJSONP.this.PreProcess(x);
                            JSONArray result = CatJSONP.this.parseList(x, listSelector, attrs);
                            if (callBack != null) {
                                callBack.catAPage(flag, page, result);
                            }
                        }
                        page += step;
                        CatJSONP.this.pages++;
                        Thread.sleep(delay);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (page < fin);
                if (callBack != null) {
                    callBack.catFin(flag, CatJSONP.this.pages, CatJSONP.this.count);
                }
            }
        }).start();
    }

    private JSONArray parseList(String jsonStr, String list, String attrs) {
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        JSONArray result = new JSONArray();
        JSONArray data = JSONKit.getArray(json, list);
        for (Object d : data) {
            JSONObject j;
            JSONObject item = j = (JSONObject)d;
            if (attrs != null && attrs.trim().length() > 0) {
                item = new JSONObject();
                for (String key : attrs.split(",")) {
                    String k;
                    String s = k = key.trim();
                    if (key.contains(":")) {
                        k = key.split(":")[0].trim();
                        s = key.split(":")[1].trim();
                    }
                    item.put(s, JSONKit.get(j, k));
                }
            }
            result.add((Object)item);
        }
        this.count += (long)result.size();
        return result;
    }
}

