/*
 * Decompiled with CFR 0.152.
 */
package cn.mvapi.message.sms.service.impl;

import cn.mvapi.common.utils.IdUtils;
import cn.mvapi.message.sms.config.SmsConfig;
import cn.mvapi.message.sms.constant.SmsConstant;
import cn.mvapi.message.sms.entity.SmsLog;
import cn.mvapi.message.sms.entity.SmsTemplateConfig;
import cn.mvapi.message.sms.enums.SmsPlatformEnum;
import cn.mvapi.message.sms.enums.SmsStatusEnum;
import cn.mvapi.message.sms.service.AliyunSmsService;
import cn.mvapi.message.sms.service.SmsExtensionService;
import cn.mvapi.message.sms.service.SmsLogService;
import com.alibaba.fastjson2.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AliyunSmsServiceImpl
implements AliyunSmsService,
SmsExtensionService {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsServiceImpl.class);
    @Autowired
    private SmsConfig smsConfig;
    @Autowired
    private SmsLogService smsLogService;

    @Override
    public String getSmsType() {
        return SmsPlatformEnum.ALIYUN.getCode();
    }

    @Override
    public void sendSms(SmsTemplateConfig smsTemplateConfig, List<String> phones, HashMap<String, Object> params) {
        Assert.notEmpty(phones, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)this.smsConfig, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)this.smsConfig.getAliyun(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u963f\u91cc\u4e91\u77ed\u4fe1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)((Object)smsTemplateConfig), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)smsTemplateConfig.getTemplateContent(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        SmsConfig.AliyunSmsProperties aliyunSmsProperties = this.smsConfig.getAliyun();
        DefaultProfile profile = DefaultProfile.getProfile((String)aliyunSmsProperties.getRegion(), (String)aliyunSmsProperties.getAccessKeyId(), (String)aliyunSmsProperties.getAccessKeySecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(String.join((CharSequence)",", phones));
        request.setSignName(smsTemplateConfig.getSignName());
        request.setTemplateCode(smsTemplateConfig.getTemplateId());
        if (params != null && !params.isEmpty()) {
            String jsonParams = JSON.toJSONString(params);
            request.setTemplateParam(jsonParams);
        }
        String content = this.templateToLog(smsTemplateConfig, params);
        this.sendSms((IAcsClient)client, request, content);
    }

    public static String getTemplateStr(String tempStr) {
        Matcher matcher = SmsConstant.SMS_TEMPLATE_PATTERN.matcher(tempStr);
        boolean i = true;
        while (matcher.find()) {
            String key = matcher.group(1);
            tempStr = tempStr.replace("${" + key + "}", "{" + key + "}");
        }
        System.out.println(tempStr);
        return tempStr;
    }

    @Override
    public void sendSms(IAcsClient client, SendSmsRequest request, String content) {
        try {
            if (this.smsConfig.getSandBox().booleanValue()) {
                List<SmsLog> smsLogs = this.buildSmsShandBoxLog(request, content);
                this.smsLogService.saveSmsLogs(smsLogs);
                return;
            }
            SendSmsResponse response = (SendSmsResponse)client.getAcsResponse((AcsRequest)request);
            if ("OK".equals(response.getCode())) {
                List<SmsLog> smsLogs = this.buildSmsSuccessLog(request, content);
                this.smsLogService.saveSmsLogs(smsLogs);
                return;
            }
            List<SmsLog> smsLogs = this.buildSmsSendErrorLog(response, request, content);
            this.smsLogService.saveSmsLogs(smsLogs);
            if (smsLogs.size() == 1) {
                throw new RuntimeException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25: " + smsLogs.get(0).getErrorMessage());
            }
            throw new RuntimeException("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u65e5\u5fd7!");
        }
        catch (ClientException e) {
            e.printStackTrace();
            List<SmsLog> smsLogs = this.buildSmsSendErrorLog(e, request, content);
            this.smsLogService.saveSmsLogs(smsLogs);
            throw new RuntimeException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private List<SmsLog> buildSmsShandBoxLog(SendSmsRequest req, String content) {
        ArrayList<SmsLog> smsLogs = new ArrayList<SmsLog>();
        for (String phone : req.getPhoneNumbers().split(",")) {
            SmsLog smsLog = new SmsLog();
            smsLog.setId(IdUtils.nextId());
            smsLog.setPlatform(this.getSmsType());
            smsLog.setPhone(phone);
            smsLog.setContent(content);
            smsLog.setStatus(SmsStatusEnum.SENT.getCode());
            smsLog.setErrorMessage("sandbox_msg");
            smsLog.setErrorCode("SMS_SYSTEM_ERROR");
            smsLog.setSendTime(LocalDateTime.now());
            smsLog.setTemplateId(req.getTemplateCode());
            smsLogs.add(smsLog);
        }
        return smsLogs;
    }

    private List<SmsLog> buildSmsSuccessLog(SendSmsRequest request, String content) {
        ArrayList<SmsLog> smsLogs = new ArrayList<SmsLog>();
        for (String phone : request.getPhoneNumbers().split(",")) {
            SmsLog smsLog = new SmsLog();
            smsLog.setId(IdWorker.getId());
            smsLog.setPlatform(this.getSmsType());
            smsLog.setPhone(phone);
            smsLog.setContent(content);
            smsLog.setStatus(SmsStatusEnum.SENT.getCode());
            smsLog.setSendTime(LocalDateTime.now());
            smsLog.setTemplateId(request.getTemplateCode());
            smsLogs.add(smsLog);
        }
        return smsLogs;
    }

    private List<SmsLog> buildSmsSendErrorLog(ClientException e, SendSmsRequest request, String content) {
        ArrayList<SmsLog> smsLogs = new ArrayList<SmsLog>();
        for (String phone : request.getPhoneNumbers().split(",")) {
            SmsLog smsLog = new SmsLog();
            smsLog.setId(IdWorker.getId());
            smsLog.setPlatform(this.getSmsType());
            smsLog.setPhone(phone);
            smsLog.setContent(content);
            smsLog.setStatus(SmsStatusEnum.FAILED.getCode());
            smsLog.setErrorMessage(e.getMessage());
            smsLog.setErrorCode(e.getErrCode());
            smsLog.setSendTime(LocalDateTime.now());
            smsLog.setTemplateId(request.getTemplateCode());
            smsLogs.add(smsLog);
        }
        return smsLogs;
    }

    private List<SmsLog> buildSmsSendErrorLog(SendSmsResponse response, SendSmsRequest request, String content) {
        ArrayList<SmsLog> smsLogs = new ArrayList<SmsLog>();
        for (String phone : request.getPhoneNumbers().split(",")) {
            SmsLog smsLog = new SmsLog();
            smsLog.setId(IdWorker.getId());
            smsLog.setPlatform(this.getSmsType());
            smsLog.setPhone(phone);
            smsLog.setContent(content);
            smsLog.setStatus(SmsStatusEnum.FAILED.getCode());
            smsLog.setErrorMessage(response.getMessage());
            smsLog.setErrorCode(response.getCode());
            smsLog.setSendTime(LocalDateTime.now());
            smsLog.setTemplateId(request.getTemplateCode());
            smsLogs.add(smsLog);
        }
        return smsLogs;
    }
}

