/*
 * Decompiled with CFR 0.152.
 */
package cn.mvapi.message.sms.service.impl;

import cn.mvapi.common.enums.YesOrNoEnum;
import cn.mvapi.data.cache.service.CacheService;
import cn.mvapi.message.sms.config.SmsConfig;
import cn.mvapi.message.sms.dao.SmsTemplateMapper;
import cn.mvapi.message.sms.entity.SmsTemplateConfig;
import cn.mvapi.message.sms.enums.SmsTempConfigEnum;
import cn.mvapi.message.sms.service.SmsExtensionService;
import cn.mvapi.message.sms.service.SmsService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SmsServiceImpl
implements SmsService {
    @Autowired
    private SmsConfig smsConfig;
    @Autowired
    private SmsTemplateMapper smsTemplateMapper;
    @Autowired
    private List<SmsExtensionService> smsExtensionServiceList;
    @Autowired(required=false)
    private CacheService cacheService;

    public void sendSms(String phone, String code) {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            map.put("code", code);
        }
        this.sendSms(this.smsConfig.getDefaultSmsType(), Collections.singletonList(phone), null, this.smsConfig.getDefaultSmsTemplateCode(), map);
    }

    public void sendSms(String phone, HashMap<String, Object> params) {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        this.sendSms(this.smsConfig.getDefaultSmsType(), Collections.singletonList(phone), null, this.smsConfig.getDefaultSmsTemplateCode(), params);
    }

    public void sendSms(List<String> phones, HashMap<String, Object> params) {
        this.sendSms(this.smsConfig.getDefaultSmsType(), phones, null, this.smsConfig.getDefaultSmsTemplateCode(), params);
    }

    public void sendSms(String smsType, List<String> phones, Long templateId, String tempNameCode, HashMap<String, Object> params) {
        SmsTemplateConfig smsTemplateConfig;
        List smsTemplateConfigList;
        Assert.notEmpty(phones, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((phones.size() <= 200 ? 1 : 0) != 0, (String)"\u5355\u6b21\u6700\u591a\u53d1\u9001\u4e24\u767e\u4e2a\u77ed\u4fe1\uff0c\u8bf7\u5c1d\u8bd5\u5206\u6279\u53d1\u9001!");
        if (this.smsConfig.getDefaultSmsTempConfig().equalsIgnoreCase(SmsTempConfigEnum.MYSQL.getCode())) {
            smsTemplateConfigList = this.smsTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SmsTemplateConfig.class).eq(StringUtils.isNotBlank((CharSequence)smsType), SmsTemplateConfig::getTemplateType, (Object)smsType)).eq(StringUtils.isNotBlank((CharSequence)tempNameCode), SmsTemplateConfig::getTemplateNameCode, (Object)tempNameCode)).eq(templateId != null, SmsTemplateConfig::getTemplateId, (Object)templateId)).eq(SmsTemplateConfig::getEnabled, (Object)YesOrNoEnum.YES.getCode()));
            Assert.notEmpty((Collection)smsTemplateConfigList, (String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u77ed\u4fe1\u6a21\u677f\uff0c\u8bf7\u5148\u914d\u7f6e\u6a21\u677f\u540e\u518d\u8bd5!");
            Assert.isTrue((smsTemplateConfigList.size() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u5b58\u5728\u591a\u6761\u91cd\u590d\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u8bd5!");
            smsTemplateConfig = (SmsTemplateConfig)((Object)smsTemplateConfigList.get(0));
        } else {
            Assert.notEmpty(this.smsConfig.getSmsTemplateConfigs(), (String)"\u672a\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\u77ed\u4fe1\u6a21\u677f\uff0c\u8bf7\u5148\u914d\u7f6e\u6a21\u677f\u540e\u518d\u8bd5!");
            smsTemplateConfigList = this.smsConfig.getSmsTemplateConfigs().stream().filter(e -> StringUtils.isBlank((CharSequence)smsType) || smsType.equalsIgnoreCase(e.getTemplateType())).filter(e -> StringUtils.isBlank((CharSequence)tempNameCode) || tempNameCode.equalsIgnoreCase(e.getTemplateNameCode())).filter(e -> templateId == null || templateId.equals(e.getTemplateId())).filter(e -> e.getEnabled() == null || YesOrNoEnum.YES.getCode().equals(e.getEnabled())).collect(Collectors.toList());
            Assert.notEmpty(smsTemplateConfigList, (String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u77ed\u4fe1\u6a21\u677f\uff0c\u8bf7\u5148\u914d\u7f6e\u6a21\u677f\u540e\u518d\u8bd5!");
            Assert.isTrue((smsTemplateConfigList.size() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u5b58\u5728\u591a\u6761\u91cd\u590d\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u8bd5!");
            smsTemplateConfig = (SmsTemplateConfig)((Object)smsTemplateConfigList.get(0));
        }
        for (SmsExtensionService smsExtensionService : this.smsExtensionServiceList) {
            if (!StringUtils.isBlank((CharSequence)smsTemplateConfig.getTemplateType()) && !smsExtensionService.getSmsType().equals(smsTemplateConfig.getTemplateType())) continue;
            smsExtensionService.sendSms(smsTemplateConfig, phones, params);
            return;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u6709\u6548\u7684\u77ed\u4fe1\u5e73\u53f0\uff0c\u8bf7\u68c0\u67e5\u77ed\u4fe1\u914d\u7f6e\u662f\u5426\u6b63\u786e");
    }

    public void sendSmsCode(String phone, String smsCodeType, String smsTemplateCode) {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)smsCodeType, (String)"\u77ed\u4fe1\u53d1\u9001\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Integer configLimit = this.smsConfig.getSmsVerifyConfig().getSendLimitInDay();
        String redisLimitKey = this.smsConfig.getSmsVerifyConfig().getRedisKeyPrefix().concat("send_limit:").concat(phone).concat(String.valueOf(LocalDateTime.now().getDayOfMonth()));
        Integer sendLimit = (Integer)this.cacheService.getCacheObject(redisLimitKey, (Object)0);
        Assert.isTrue((sendLimit < configLimit ? 1 : 0) != 0, (String)"\u77ed\u4fe1\u53d1\u9001\u6761\u6570\u5df2\u8d85\u8fc7\u5f53\u65e5\u9650\u5236\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        int code = new Random().nextInt(899999) + 100000;
        String phoneCodeKey = this.smsConfig.getSmsVerifyConfig().getRedisKeyPrefix().concat("phone_code_key:").concat(phone).concat(smsCodeType);
        this.cacheService.setCacheObject(phoneCodeKey, (Object)code, this.smsConfig.getSmsVerifyConfig().getCodeTimeOut(), TimeUnit.MINUTES);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        this.sendSms(null, Collections.singletonList(phone), null, smsTemplateCode, params);
        sendLimit = sendLimit + 1;
        this.cacheService.setCacheObject(redisLimitKey, (Object)sendLimit, Integer.valueOf(24), TimeUnit.HOURS);
    }

    public boolean checkPhoneCode(String phone, String smsCodeType, String code) {
        Assert.hasText((String)code, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        String phoneCodeKey = this.smsConfig.getSmsVerifyConfig().getRedisKeyPrefix().concat("phone_code_key:").concat(phone).concat(smsCodeType);
        String verCode = (String)this.cacheService.getCacheObject(phoneCodeKey);
        Assert.notNull((Object)verCode, (String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u540e\u518d\u8bd5!");
        Assert.isTrue((boolean)verCode.equals(code), (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8f93\u5165!");
        return true;
    }
}

