/*
 * Decompiled with CFR 0.152.
 */
package cn.mvapi.message.sms.service.impl;

import cn.hutool.core.lang.Assert;
import cn.mvapi.common.utils.IdUtils;
import cn.mvapi.message.sms.config.SmsConfig;
import cn.mvapi.message.sms.constant.SmsConstant;
import cn.mvapi.message.sms.entity.SmsLog;
import cn.mvapi.message.sms.entity.SmsTemplateConfig;
import cn.mvapi.message.sms.entity.TencentSmsConfig;
import cn.mvapi.message.sms.enums.SmsPlatformEnum;
import cn.mvapi.message.sms.enums.SmsStatusEnum;
import cn.mvapi.message.sms.service.SmsExtensionService;
import cn.mvapi.message.sms.service.SmsLogService;
import cn.mvapi.message.sms.service.TencentSmsService;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TencentSmsServiceImpl
implements TencentSmsService,
SmsExtensionService {
    @Autowired
    private SmsConfig smsConfig;
    @Autowired
    private SmsLogService smsLogService;

    @Override
    public void sendSms(SmsTemplateConfig smsTemplateConfig, List<String> phones, HashMap<String, Object> params) {
        Assert.notEmpty(phones, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.smsConfig, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)this.smsConfig.getTencent(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u817e\u8baf\u4e91\u77ed\u4fe1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)this.smsConfig.getTencent().getSmsConfig(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u817e\u8baf\u4e91\u77ed\u4fe1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)smsTemplateConfig), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)smsTemplateConfig.getTemplateContent(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HttpProfile httpProfile = this.smsConfig.getTencent().getHttpProfile();
        TencentSmsConfig tencentSmsConfig = this.smsConfig.getTencent().getSmsConfig();
        SendSmsRequest req = this.smsConfig.getTencent().getSendConfig();
        if (StringUtils.isNotBlank((CharSequence)smsTemplateConfig.getSignName())) {
            req.setSignName(smsTemplateConfig.getSignName());
        }
        if (StringUtils.isNotBlank((CharSequence)smsTemplateConfig.getTemplateId())) {
            req.setTemplateId(smsTemplateConfig.getTemplateId());
        }
        if (params != null && params.size() > 0) {
            String[] smsParams = this.buildSmsParams(smsTemplateConfig, params);
            req.setTemplateParamSet(smsParams);
        }
        req.setPhoneNumberSet(phones.toArray(new String[0]));
        String content = this.templateToLog(smsTemplateConfig, params);
        this.sendSms(httpProfile, tencentSmsConfig, req, content);
    }

    private String[] buildSmsParams(SmsTemplateConfig smsTemplateConfig, HashMap<String, Object> params) {
        ArrayList<String> variables = new ArrayList<String>();
        Matcher matcher = SmsConstant.SMS_TEMPLATE_PATTERN.matcher(smsTemplateConfig.getTemplateContent());
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = String.valueOf(params.get(key));
            variables.add(value);
        }
        return variables.toArray(new String[0]);
    }

    public static String getTemplateStr(String tempStr) {
        Matcher matcher = SmsConstant.SMS_TEMPLATE_PATTERN.matcher(tempStr);
        int i = 1;
        while (matcher.find()) {
            String key = matcher.group(1);
            tempStr = tempStr.replace("${" + key + "}", "{" + i++ + "}");
        }
        System.out.println(tempStr);
        return tempStr;
    }

    @Override
    public void sendSms(HttpProfile httpProfile, TencentSmsConfig tencentSmsConfig, SendSmsRequest req, String content) {
        try {
            if (httpProfile == null) {
                httpProfile = new HttpProfile();
            }
            if (tencentSmsConfig == null) {
                tencentSmsConfig = new TencentSmsConfig();
            }
            if (req == null) {
                req = new SendSmsRequest();
            }
            if (StringUtils.isBlank((CharSequence)httpProfile.getEndpoint())) {
                httpProfile.setEndpoint("sms.tencentcloudapi.com");
            }
            if (tencentSmsConfig.getRegion() == null) {
                tencentSmsConfig.setRegion("ap-guangzhou");
            }
            Assert.notBlank((CharSequence)tencentSmsConfig.getSecretId(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0csecretId \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)tencentSmsConfig.getSecretKey(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0csecretKey \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Credential cred = new Credential(tencentSmsConfig.getSecretId(), tencentSmsConfig.getSecretKey());
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);
            SmsClient client = new SmsClient(cred, tencentSmsConfig.getRegion(), clientProfile);
            Assert.notBlank((CharSequence)req.getSmsSdkAppId(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0csdkAppId \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)req.getSignName(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)req.getTemplateId(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notNull((Object)req.getPhoneNumberSet(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Assert.notEmpty((Object[])req.getPhoneNumberSet(), (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.isTrue((req.getPhoneNumberSet().length <= 200 ? 1 : 0) != 0, (String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u5355\u6b21\u53d1\u9001\u7684\u624b\u673a\u53f7\u4e0d\u80fd\u5927\u4e8e200\u4e2a!", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)content)) {
                content = "\u3010" + req.getSignName() + "\u3011tempId:" + req.getTemplateId();
                if (req.getTemplateParamSet() != null && req.getTemplateParamSet().length > 0) {
                    content = content + " params:" + Arrays.toString(req.getTemplateParamSet());
                }
            } else {
                content = "\u3010" + req.getSignName() + "\u3011" + content;
            }
            if (this.smsConfig.getSandBox().booleanValue()) {
                List<SmsLog> smsLogs = this.buildSmsShandBoxLog(req, content);
                this.smsLogService.saveSmsLogs(smsLogs);
                return;
            }
            SendSmsResponse res = client.SendSms(req);
            String finalContent = content;
            String templateId = req.getTemplateId();
            List<SmsLog> smsLogs = Arrays.stream(res.getSendStatusSet()).map(e -> this.smsResToLog((SendStatus)e, finalContent, templateId)).collect(Collectors.toList());
            this.smsLogService.saveSmsLogs(smsLogs);
            if (!smsLogs.stream().allMatch(e -> e.getStatus().equals(SmsStatusEnum.SENT.getCode()))) {
                if (smsLogs.size() == 1) {
                    throw new RuntimeException(smsLogs.get(0).getErrorMessage());
                }
                throw new RuntimeException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7!");
            }
        }
        catch (TencentCloudSDKException | RuntimeException e2) {
            e2.printStackTrace();
            List<SmsLog> smsLogs = this.buildSmsSendErrorLog((Exception)e2, req, content);
            this.smsLogService.saveSmsLogs(smsLogs);
            throw e2;
        }
    }

    private List<SmsLog> buildSmsShandBoxLog(SendSmsRequest req, String content) {
        ArrayList<SmsLog> smsLogs = new ArrayList<SmsLog>();
        for (String phone : req.getPhoneNumberSet()) {
            SmsLog smsLog = new SmsLog();
            smsLog.setId(IdUtils.nextId());
            smsLog.setPlatform(this.getSmsType());
            smsLog.setPhone(phone);
            smsLog.setContent(content);
            smsLog.setStatus(SmsStatusEnum.SENT.getCode());
            smsLog.setErrorMessage("sandbox_msg");
            smsLog.setErrorCode("SMS_SYSTEM_ERROR");
            smsLog.setSendTime(LocalDateTime.now());
            smsLog.setTemplateId(req.getTemplateId());
            smsLogs.add(smsLog);
        }
        return smsLogs;
    }

    private List<SmsLog> buildSmsSendErrorLog(Exception e, SendSmsRequest req, String content) {
        ArrayList<SmsLog> smsLogs = new ArrayList<SmsLog>();
        for (String phone : req.getPhoneNumberSet()) {
            SmsLog smsLog = new SmsLog();
            smsLog.setId(IdUtils.nextId());
            smsLog.setPlatform(this.getSmsType());
            smsLog.setPhone(phone);
            smsLog.setContent(content);
            smsLog.setStatus(SmsStatusEnum.FAILED.getCode());
            smsLog.setErrorMessage(e.getMessage());
            smsLog.setErrorCode("SMS_SYSTEM_ERROR");
            smsLog.setSendTime(LocalDateTime.now());
            smsLog.setTemplateId(req.getTemplateId());
            smsLogs.add(smsLog);
        }
        return smsLogs;
    }

    private SmsLog smsResToLog(SendStatus e, String content, String templateId) {
        SmsLog smsLog = new SmsLog();
        smsLog.setId(IdUtils.nextId());
        smsLog.setPlatform(this.getSmsType());
        smsLog.setPhone(e.getPhoneNumber());
        smsLog.setContent(content);
        if (e.getCode().equalsIgnoreCase("ok")) {
            smsLog.setStatus(SmsStatusEnum.SENT.getCode());
        } else {
            smsLog.setStatus(SmsStatusEnum.FAILED.getCode());
            smsLog.setErrorMessage(e.getMessage());
            smsLog.setErrorCode(e.getCode());
        }
        smsLog.setSendTime(LocalDateTime.now());
        smsLog.setTemplateId(templateId);
        return smsLog;
    }

    @Override
    public String getSmsType() {
        return SmsPlatformEnum.TENCENT.getCode();
    }
}

