/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.wlld.matrixTools.Matrix;
import org.wlld.tools.RgbRegression;

public class RGBNorm {
    private double[] rgbAll;
    private double norm;
    private int nub;
    private double[] rgb;
    private double[] rgbUp;
    private List<double[]> rgbs = new ArrayList<double[]>();
    private List<Double> powers = new ArrayList<Double>();
    private RgbRegression rgbRegression;
    private int len;
    private double varAll = 1.0;
    private Matrix avgMatrix;
    private Matrix varMatrix;
    private double gmParameter;
    private double probabilitySigma = 0.0;

    public double getVarAll() {
        return this.varAll;
    }

    public Matrix getAvgMatrix() {
        return this.avgMatrix;
    }

    public Matrix getVarMatrix() {
        return this.varMatrix;
    }

    public List<double[]> getRgbs() {
        return this.rgbs;
    }

    public RgbRegression getRgbRegression() {
        return this.rgbRegression;
    }

    public void setRgbRegression(RgbRegression rgbRegression) {
        this.rgbRegression = rgbRegression;
    }

    public RGBNorm(double[] rgb, int len) {
        this.len = len;
        this.rgbAll = new double[len];
        this.rgb = new double[len];
        this.rgbUp = rgb;
        this.gmParameter = new Random().nextDouble();
    }

    public RGBNorm() {
    }

    public void syn() {
        this.rgbUp = this.rgb;
    }

    public void clearRGB() {
        this.probabilitySigma = 0.0;
        this.rgbs.clear();
        this.powers.clear();
    }

    public void setGmFeature(double[] feature, double probability) {
        this.rgbs.add(feature);
        this.powers.add(probability);
        this.probabilitySigma = probability + this.probabilitySigma;
    }

    public void clear() {
        this.rgbAll = new double[this.len];
        this.nub = 0;
        for (int i = 0; i < this.rgb.length; ++i) {
            this.rgbUp[i] = this.rgb[i];
        }
        this.rgbs.clear();
    }

    public int getNub() {
        return this.nub;
    }

    public boolean compare() {
        boolean isNext = false;
        for (int i = 0; i < this.rgb.length; ++i) {
            if (this.rgb[i] == this.rgbUp[i]) continue;
            isNext = true;
            break;
        }
        return isNext;
    }

    public double getEDist(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = x[i] - this.rgbUp[i];
        }
        double sigma = 0.0;
        for (int i = 0; i < y.length; ++i) {
            sigma += Math.pow(y[i], 2.0);
        }
        return Math.sqrt(sigma);
    }

    public void setColor(double[] rgb) {
        for (int i = 0; i < rgb.length; ++i) {
            this.rgbAll[i] = this.rgbAll[i] + rgb[i];
        }
        this.rgbs.add(rgb);
        ++this.nub;
    }

    private Matrix average(Matrix matrix) throws Exception {
        int i;
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix avgMatrix = new Matrix(x, 1);
        boolean isPower = this.powers.size() > 1;
        for (i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                double power = !isPower ? 1.0 : this.powers.get(j);
                double nub = avgMatrix.getNumber(i, 0) + matrix.getNumber(i, j) * power;
                avgMatrix.setNub(i, 0, nub);
            }
        }
        for (i = 0; i < x; ++i) {
            double nub = this.probabilitySigma > 0.0 ? avgMatrix.getNumber(i, 0) / this.probabilitySigma : avgMatrix.getNumber(i, 0) / (double)y;
            avgMatrix.setNub(i, 0, nub);
        }
        return avgMatrix;
    }

    private Matrix getVariance(Matrix matrix, Matrix avgMatrix) throws Exception {
        int i;
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix varMatrix = new Matrix(x, 1);
        boolean isPower = this.powers.size() > 1;
        for (i = 0; i < x; ++i) {
            double avg = avgMatrix.getNumber(i, 0);
            for (int j = 0; j < y; ++j) {
                double power = !isPower ? 1.0 : this.powers.get(j);
                double sub = Math.pow(matrix.getNumber(i, j) - avg, 2.0) * power;
                varMatrix.setNub(i, 0, sub + varMatrix.getNumber(i, 0));
            }
        }
        for (i = 0; i < x; ++i) {
            double nub = this.probabilitySigma > 0.0 ? varMatrix.getNumber(i, 0) / this.probabilitySigma : varMatrix.getNumber(i, 0) / (double)y;
            varMatrix.setNub(i, 0, nub);
        }
        return varMatrix;
    }

    public double[] getFeature() throws Exception {
        int avgLen = this.avgMatrix.getX();
        int length = avgLen * 2 + 1;
        double[] feature = new double[length];
        for (int i = 0; i < length - 1; ++i) {
            if (i < avgLen) {
                feature[i] = this.avgMatrix.getNumber(i, 0);
                continue;
            }
            int t = i - avgLen;
            feature[i] = this.varMatrix.getNumber(t, 0);
        }
        feature[length - 1] = this.gmParameter;
        return feature;
    }

    public void insertFeature(double[] feature) throws Exception {
        int length = feature.length - 1;
        int size = length / 2;
        this.avgMatrix = new Matrix(size, 1);
        this.varMatrix = new Matrix(size, 1);
        this.gmParameter = feature[length];
        this.varAll = 1.0;
        for (int i = 0; i < length; ++i) {
            if (i < size) {
                this.avgMatrix.setNub(i, 0, feature[i]);
                continue;
            }
            int t = i - size;
            double var = feature[i];
            this.varMatrix.setNub(t, 0, var);
            this.varAll *= Math.sqrt(var);
        }
    }

    public void gm() throws Exception {
        int size = this.rgbs.size();
        if (size > 0) {
            int i;
            Matrix matrix = new Matrix(this.len, size);
            for (i = 0; i < size; ++i) {
                double[] rgb = this.rgbs.get(i);
                for (int j = 0; j < this.len; ++j) {
                    matrix.setNub(j, i, rgb[j]);
                }
            }
            this.avgMatrix = this.average(matrix);
            this.varMatrix = this.getVariance(matrix, this.avgMatrix);
            this.varAll = 1.0;
            for (i = 0; i < this.len; ++i) {
                double var = Math.sqrt(this.varMatrix.getNumber(i, 0));
                this.varAll *= var;
            }
            if (this.probabilitySigma > 0.0) {
                this.gmParameter = this.probabilitySigma / (double)this.rgbs.size();
            }
        }
    }

    public double getGMProbability(double[] feature) throws Exception {
        double zSigma = 0.0;
        int size = feature.length;
        for (int i = 0; i < size; ++i) {
            double sub = Math.pow(feature[i] - this.avgMatrix.getNumber(i, 0), 2.0) / this.varMatrix.getNumber(i, 0);
            zSigma = sub + zSigma;
        }
        double one = 1.0 / (Math.pow(Math.sqrt(Math.PI * 2), size) * this.varAll);
        double two = Math.exp(zSigma * -0.5);
        double n = one * two * this.gmParameter;
        return n;
    }

    public double getGmParameter() {
        return this.gmParameter;
    }

    public void setGmParameter(double gmParameter) {
        this.gmParameter = gmParameter;
    }

    public void norm() {
        double sigma = 0.0;
        if (this.nub > 0) {
            for (int i = 0; i < this.rgb.length; ++i) {
                double rgbc;
                this.rgb[i] = rgbc = this.rgbAll[i] / (double)this.nub;
                sigma += Math.pow(rgbc, 2.0);
            }
            this.norm = Math.sqrt(sigma);
        }
    }

    public void finish() {
        RGBListSort rgbListSort = new RGBListSort();
        Collections.sort(this.rgbs, rgbListSort);
    }

    public double getNorm() {
        return this.norm;
    }

    public double[] getRgb() {
        return this.rgb;
    }

    class RGBListSort
    implements Comparator<double[]> {
        RGBListSort() {
        }

        @Override
        public int compare(double[] o1, double[] o2) {
            double o1Norm = 0.0;
            double o2Norm = 0.0;
            for (int i = 0; i < o1.length; ++i) {
                o1Norm += Math.pow(o1[i], 2.0);
                o2Norm += Math.pow(o2[i], 2.0);
            }
            if (o1Norm > o2Norm) {
                return 1;
            }
            if (o1Norm < o2Norm) {
                return -1;
            }
            return 0;
        }
    }
}

