/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SentenceModel {
    private final List<String[]> sentenceList = new ArrayList<String[]>();
    private final Set<String> wordSet = new HashSet<String>();
    private final String splitWord;

    public SentenceModel(String splitWord) {
        this.splitWord = splitWord;
    }

    public SentenceModel() {
        this.splitWord = null;
    }

    public void setSentenceBySplitWord(String sentence) throws Exception {
        if (this.splitWord == null || this.splitWord.isEmpty()) {
            throw new Exception("\u6ca1\u6709\u8bbe\u7f6e\u9694\u65ad\u7b26\uff0c\u65e0\u6cd5\u4f7f\u7528\u57fa\u4e8e\u9694\u65ad\u7b26\u7684\u5207\u5272");
        }
        String[] words = sentence.split(this.splitWord);
        Collections.addAll(this.wordSet, words);
        this.sentenceList.add(words);
    }

    public void setSentence(String sentence) {
        String[] words = new String[sentence.length()];
        for (int i = 0; i < sentence.length(); ++i) {
            String word;
            words[i] = word = sentence.substring(i, i + 1);
            this.wordSet.add(word);
        }
        this.sentenceList.add(words);
    }

    public List<String[]> getSentenceList() {
        return this.sentenceList;
    }

    public String getSplitWord() {
        return this.splitWord;
    }

    public Set<String> getWordSet() {
        return this.wordSet;
    }
}

