/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.entity;

import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;

public class ThreeChannelMatrix {
    private Matrix matrixR;
    private Matrix matrixG;
    private Matrix matrixB;
    private Matrix H;
    private int x;
    private int y;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public double getDist(ThreeChannelMatrix th) throws Exception {
        if (th.getX() == this.x && th.getY() == this.y) {
            double subR = Math.abs(this.matrixOperation.sub(this.matrixR, th.getMatrixR()).getAVG());
            double subG = Math.abs(this.matrixOperation.sub(this.matrixG, th.getMatrixG()).getAVG());
            double subB = Math.abs(this.matrixOperation.sub(this.matrixB, th.getMatrixB()).getAVG());
            return (subR + subB + subG) / 3.0;
        }
        throw new Exception("\u56fe\u50cf\u5c3a\u5bf8\u5927\u5c0f\u4e0d\u5339\u914d\uff0c\u672c\u56fe\u50cf\u5c3a\u5bf8x\u662f\uff1a" + this.x + ",y:" + this.y + "\u3002\u5f85\u5339\u914d\u5c3a\u5bf8\u56fe\u50cf x:" + th.getX() + ",y:" + th.getY());
    }

    public void add(double nub, boolean add) throws Exception {
        if (add) {
            this.matrixOperation.mathAdd(this.matrixR, nub);
            this.matrixOperation.mathAdd(this.matrixG, nub);
            this.matrixOperation.mathAdd(this.matrixB, nub);
        } else {
            this.matrixOperation.mathSub(this.matrixR, nub);
            this.matrixOperation.mathSub(this.matrixG, nub);
            this.matrixOperation.mathSub(this.matrixB, nub);
        }
    }

    public ThreeChannelMatrix copy() throws Exception {
        ThreeChannelMatrix copyThreeChannelMatrix = new ThreeChannelMatrix();
        copyThreeChannelMatrix.setX(this.x);
        copyThreeChannelMatrix.setY(this.y);
        Matrix matrixCR = new Matrix(this.x, this.y);
        Matrix matrixCG = new Matrix(this.x, this.y);
        Matrix matrixCB = new Matrix(this.x, this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                matrixCR.setNub(i, j, this.matrixR.getNumber(i, j));
                matrixCG.setNub(i, j, this.matrixG.getNumber(i, j));
                matrixCB.setNub(i, j, this.matrixB.getNumber(i, j));
            }
        }
        copyThreeChannelMatrix.setMatrixR(matrixCR);
        copyThreeChannelMatrix.setMatrixG(matrixCG);
        copyThreeChannelMatrix.setMatrixB(matrixCB);
        return copyThreeChannelMatrix;
    }

    public void fill(int x, int y, ThreeChannelMatrix fillThreeChannelMatrix) throws Exception {
        int xIndex = x + fillThreeChannelMatrix.getX();
        int yIndex = y + fillThreeChannelMatrix.getY();
        Matrix matrixFR = fillThreeChannelMatrix.getMatrixR();
        Matrix matrixFG = fillThreeChannelMatrix.getMatrixG();
        Matrix matrixFB = fillThreeChannelMatrix.getMatrixB();
        if (xIndex <= this.x && yIndex <= this.y) {
            for (int i = x; i < xIndex; ++i) {
                for (int j = y; j < yIndex; ++j) {
                    this.matrixR.setNub(i, j, matrixFR.getNumber(i - x, j - y));
                    this.matrixG.setNub(i, j, matrixFG.getNumber(i - x, j - y));
                    this.matrixB.setNub(i, j, matrixFB.getNumber(i - x, j - y));
                }
            }
        } else {
            throw new Exception("The filled image goes beyond the boundary !");
        }
    }

    public ThreeChannelMatrix cutChannel(int x, int y, int XSize, int YSize) throws Exception {
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        threeChannelMatrix.setX(XSize);
        threeChannelMatrix.setY(YSize);
        int xLen = this.matrixR.getX();
        int yLen = this.matrixR.getY();
        if (x < 0 || y < 0 || x + XSize > xLen || y + YSize > yLen) {
            throw new Exception("size out,xLen:" + xLen + ",yLen:" + yLen + ",x:" + x + ",y:" + y + ",xSize:" + (x + XSize) + ",ySize:" + (y + YSize));
        }
        Matrix matrixR = this.matrixR.getSonOfMatrix(x, y, XSize, YSize);
        Matrix matrixG = this.matrixG.getSonOfMatrix(x, y, XSize, YSize);
        Matrix matrixB = this.matrixB.getSonOfMatrix(x, y, XSize, YSize);
        Matrix matrixH = this.H.getSonOfMatrix(x, y, XSize, YSize);
        threeChannelMatrix.setX(XSize);
        threeChannelMatrix.setY(YSize);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        threeChannelMatrix.setH(matrixH);
        return threeChannelMatrix;
    }

    public Matrix getH() {
        return this.H;
    }

    public void setH(Matrix h) {
        this.H = h;
    }

    public Matrix getMatrixR() {
        return this.matrixR;
    }

    public void setMatrixR(Matrix matrixR) {
        this.matrixR = matrixR;
    }

    public Matrix getMatrixG() {
        return this.matrixG;
    }

    public void setMatrixG(Matrix matrixG) {
        this.matrixG = matrixG;
    }

    public Matrix getMatrixB() {
        return this.matrixB;
    }

    public void setMatrixB(Matrix matrixB) {
        this.matrixB = matrixB;
    }
}

