/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.gameRobot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wlld.gameRobot.Action;
import org.wlld.gameRobot.DynamicState;
import org.wlld.gameRobot.ValueFunction;
import org.wlld.matrixTools.Matrix;

public class DynamicProgramming {
    private List<DynamicState> dynamicStateList = new ArrayList<DynamicState>();
    private Map<Integer, Action> actionMap = new HashMap<Integer, Action>();
    private List<Integer> bestStrategy = new ArrayList<Integer>();
    private double gaMa = 0.5;
    private double valueTh = 1.0E-4;
    private int maxTimes = 500;

    public void setMaxTimes(int maxTimes) {
        this.maxTimes = maxTimes;
    }

    public void setValueTh(double valueTh) {
        this.valueTh = valueTh;
    }

    public void setGaMa(double gaMa) {
        this.gaMa = gaMa;
    }

    public List<DynamicState> getDynamicStateList() {
        return this.dynamicStateList;
    }

    public Map<Integer, Action> getActionMap() {
        return this.actionMap;
    }

    public void gameStart() {
        for (DynamicState dynamicState : this.dynamicStateList) {
            if (dynamicState.isFinish()) continue;
            dynamicState.add();
            Map<Integer, List<DynamicState>> sonStatesMap = dynamicState.getSonStatesMap();
            int[] stateId = dynamicState.getStateId();
            for (Map.Entry<Integer, Action> actionEntry : this.actionMap.entrySet()) {
                Action action = actionEntry.getValue();
                int actionId = action.getActionId();
                List<int[]> stateList = action.action(stateId);
                for (int[] myStateId : stateList) {
                    DynamicState state = this.getStateByStateId(myStateId);
                    if (sonStatesMap.containsKey(actionId)) {
                        List<DynamicState> dynamicStates = sonStatesMap.get(actionId);
                        if (!this.isHere(dynamicStates, state.getStateId())) {
                            dynamicStates.add(state);
                        }
                    } else {
                        ArrayList<DynamicState> dynamicStateList = new ArrayList<DynamicState>();
                        dynamicStateList.add(state);
                        sonStatesMap.put(actionId, dynamicStateList);
                    }
                    Map<Integer, Integer> profitMap = state.getProfitMap();
                    state.add();
                    int profit = action.getProfit(stateId);
                    if (profitMap.containsKey(profit)) {
                        profitMap.put(profit, profitMap.get(profit) + 1);
                        continue;
                    }
                    profitMap.put(profit, 1);
                }
            }
        }
    }

    public Matrix getValueMatrix() throws Exception {
        int size = this.dynamicStateList.size();
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < size; ++i) {
            DynamicState dynamicState = this.dynamicStateList.get(i);
            int[] stateId = dynamicState.getStateId();
            int x = stateId[0];
            int y = stateId[1];
            if (x > maxX) {
                maxX = x;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        Matrix matrix = new Matrix(maxY + 1, maxX + 1);
        for (int i = 0; i < size; ++i) {
            DynamicState dynamicState = this.dynamicStateList.get(i);
            int[] stateId = dynamicState.getStateId();
            double value = dynamicState.getValue();
            matrix.setNub(stateId[1], stateId[0], value);
        }
        return matrix;
    }

    public List<ValueFunction> getValueFunction() {
        ArrayList<ValueFunction> valueFunctions = new ArrayList<ValueFunction>();
        int size = this.dynamicStateList.size();
        for (int i = 0; i < size; ++i) {
            DynamicState dynamicState = this.dynamicStateList.get(i);
            ValueFunction valueFunction = new ValueFunction();
            valueFunction.setStateId(dynamicState.getStateId());
            valueFunction.setValue(dynamicState.getValue());
            valueFunctions.add(valueFunction);
        }
        return valueFunctions;
    }

    public List<Integer> getBestAction(int[] stateId) {
        ArrayList<Integer> actions = new ArrayList<Integer>();
        DynamicState state = this.getStateByStateId(stateId);
        if (state != null) {
            Map<Integer, List<DynamicState>> sonStatesMap = state.getSonStatesMap();
            double maxValue = 0.0;
            boolean isFirstOne = true;
            for (Map.Entry<Integer, List<DynamicState>> entry : sonStatesMap.entrySet()) {
                List<DynamicState> sonStates = entry.getValue();
                double maxValue2 = 0.0;
                boolean isFirstTwo = true;
                for (DynamicState dynamicState : sonStates) {
                    double myValue = dynamicState.getValue();
                    if (!(myValue > maxValue2) && !isFirstTwo) continue;
                    isFirstTwo = false;
                    maxValue2 = myValue;
                }
                if (!(maxValue2 > maxValue) && !isFirstOne) continue;
                isFirstOne = false;
                maxValue = maxValue2;
            }
            block2: for (Map.Entry<Integer, List<DynamicState>> entry : sonStatesMap.entrySet()) {
                int actionId = entry.getKey();
                List<DynamicState> sonStates = entry.getValue();
                for (DynamicState dynamicState : sonStates) {
                    if (dynamicState.getValue() != maxValue) continue;
                    actions.add(actionId);
                    continue block2;
                }
            }
        }
        return actions;
    }

    public void strategyStudy() throws Exception {
        int times = 0;
        boolean isDifferent = true;
        do {
            int size = this.dynamicStateList.size();
            for (int i = 0; i < size; ++i) {
                DynamicState dynamicState = this.dynamicStateList.get(i);
                if (dynamicState.isFinish()) continue;
                int actionId = this.getBestStrategyByPro(dynamicState);
                dynamicState.setBestActionId(actionId);
            }
            if (times > 0) {
                isDifferent = this.compareStrategy();
            }
            if (!isDifferent) continue;
            this.updateBestStrategy();
            this.strategyEvaluation();
        } while (isDifferent && ++times < this.maxTimes);
    }

    private boolean isHere(List<DynamicState> dynamicStates, int[] stateId) {
        boolean isHere = false;
        for (DynamicState dynamicState : dynamicStates) {
            if (!Arrays.equals(dynamicState.getStateId(), stateId)) continue;
            isHere = true;
            break;
        }
        return isHere;
    }

    private DynamicState getStateByStateId(int[] stateId) {
        DynamicState state = null;
        for (DynamicState dynamicState : this.dynamicStateList) {
            if (!Arrays.equals(dynamicState.getStateId(), stateId)) continue;
            state = dynamicState;
            break;
        }
        return state;
    }

    private void updateBestStrategy() {
        int size = this.dynamicStateList.size();
        for (int i = 0; i < size; ++i) {
            DynamicState dynamicState = this.dynamicStateList.get(i);
            if (!dynamicState.isFinish()) {
                this.bestStrategy.add(dynamicState.getBestActionId());
                continue;
            }
            this.bestStrategy.add(0);
        }
    }

    private boolean compareStrategy() {
        int size = this.dynamicStateList.size();
        boolean isDifferent = false;
        for (int i = 0; i < size; ++i) {
            DynamicState dynamicState = this.dynamicStateList.get(i);
            int actionId = this.bestStrategy.get(i);
            if (dynamicState.getBestActionId() == actionId) continue;
            isDifferent = true;
            break;
        }
        return isDifferent;
    }

    private int getBestStrategyByPro(DynamicState dynamicState) throws Exception {
        Map<Integer, List<DynamicState>> sonStatesMap = dynamicState.getSonStatesMap();
        double maxValue = 0.0;
        boolean isFirst = true;
        int bestActionId = 0;
        for (Map.Entry<Integer, List<DynamicState>> entry : sonStatesMap.entrySet()) {
            int actionId = entry.getKey();
            double value = this.getValueByAction(dynamicState, actionId);
            if (!(value > maxValue) && !isFirst) continue;
            isFirst = false;
            maxValue = value;
            bestActionId = actionId;
        }
        return bestActionId;
    }

    private void strategyEvaluation() throws Exception {
        double maxSub;
        do {
            maxSub = 0.0;
            for (DynamicState dynamicState : this.dynamicStateList) {
                double sub;
                if (dynamicState.isFinish() || !((sub = this.valueEvaluation(dynamicState)) > maxSub)) continue;
                maxSub = sub;
            }
        } while (maxSub >= this.valueTh);
    }

    private double getValueByAction(DynamicState dynamicState, int actionId) throws Exception {
        Map<Integer, List<DynamicState>> sonStatesMap = dynamicState.getSonStatesMap();
        List<DynamicState> sonStateListByAction = sonStatesMap.get(actionId);
        if (sonStateListByAction == null) {
            throw new Exception("\u8be5\u72b6\u6001\u65e0\u4e0b\u4e00\u6b65\u52a8\u4f5c\uff01\u53ef\u80fd\u8be5\u72b6\u6001\u5c5e\u4e8e\u7ec8\u7ed3\u6001\uff0c\u4f46\u5e76\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u7ec8\u7ed3\u6001\uff01");
        }
        double number = dynamicState.getNumber();
        double updateValue = 0.0;
        for (DynamicState sonState : sonStateListByAction) {
            Map<Integer, Integer> profitMap = sonState.getProfitMap();
            double sonNumber = sonState.getNumber();
            double sonPro = sonNumber / number;
            double value = sonState.getValue() * this.gaMa;
            double sigmaR = 0.0;
            for (Map.Entry<Integer, Integer> entryProfit : profitMap.entrySet()) {
                double profit = entryProfit.getKey().intValue();
                double profitNumber = entryProfit.getValue().intValue();
                double profitPro = profitNumber / sonNumber * sonPro;
                double v = (value + profit) * profitPro;
                sigmaR += v;
            }
            updateValue += sigmaR;
        }
        return updateValue;
    }

    private double valueEvaluation(DynamicState dynamicState) throws Exception {
        double myValue = dynamicState.getValue();
        int bestActionId = dynamicState.getBestActionId();
        double updateValue = this.getValueByAction(dynamicState, bestActionId);
        dynamicState.setValue(updateValue);
        return Math.abs(myValue - updateValue);
    }
}

