/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage;

import java.util.ArrayList;
import java.util.List;
import org.wlld.naturalLanguage.LangBody;
import org.wlld.naturalLanguage.Sentence;
import org.wlld.naturalLanguage.Tokenizer;
import org.wlld.naturalLanguage.Word;
import org.wlld.naturalLanguage.WordTemple;
import org.wlld.naturalLanguage.WorldBody;
import org.wlld.randomForest.RandomForest;
import org.wlld.tools.ArithUtil;

public class Talk {
    private List<WorldBody> allWorld;
    private RandomForest randomForest;
    private List<List<String>> wordTimes;
    private WordTemple wordTemple;

    public Talk(WordTemple wordTemple) {
        this.wordTemple = wordTemple;
        this.allWorld = wordTemple.getAllWorld();
        this.randomForest = wordTemple.getRandomForest();
        this.wordTimes = wordTemple.getWordTimes();
    }

    public List<List<String>> getSplitWord(String sentence) {
        List<Sentence> sentences = this.splitSentence(sentence);
        ArrayList<List<String>> words = new ArrayList<List<String>>();
        for (Sentence sentence1 : sentences) {
            words.add(sentence1.getKeyWords());
        }
        return words;
    }

    private List<Sentence> splitSentence(String sentence) {
        String[] sens = sentence.replace(" ", "").split("\uff0c|\u3002|\uff1f|\uff01|\uff1b|\u3001|\uff1a");
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        for (int i = 0; i < sens.length; ++i) {
            String mySentence = sens[i];
            List<Sentence> sentenceList = this.catchSentence(mySentence);
            int key = 0;
            int nub = 0;
            for (int j = 0; j < sentenceList.size(); ++j) {
                Sentence sentence1 = sentenceList.get(j);
                this.restructure(sentence1);
                int size = sentence1.getKeyWords().size();
                if (size <= nub) continue;
                key = j;
                nub = size;
            }
            sentences.add(sentenceList.get(key));
        }
        return sentences;
    }

    public List<Integer> talk(String sentence) throws Exception {
        if (!this.wordTemple.isSplitWord()) {
            ArrayList<Integer> typeList = new ArrayList<Integer>();
            List<Sentence> sentences = this.splitSentence(sentence);
            if (this.randomForest != null) {
                for (Sentence sentence1 : sentences) {
                    List<Integer> features = sentence1.getFeatures();
                    List<String> keyWords = sentence1.getKeyWords();
                    int wrong = 0;
                    int wordNumber = keyWords.size();
                    for (int i = 0; i < 8; ++i) {
                        List<String> words;
                        int nub = 0;
                        if (keyWords.size() > i && (nub = this.getNub(words = this.wordTimes.get(i), keyWords.get(i))) == 0) {
                            ++wrong;
                        }
                        features.add(nub);
                    }
                    int type = 0;
                    if (ArithUtil.div(wrong, wordNumber) < this.wordTemple.getGarbageTh()) {
                        LangBody langBody = new LangBody();
                        langBody.setA1(features.get(0));
                        langBody.setA2(features.get(1));
                        langBody.setA3(features.get(2));
                        langBody.setA4(features.get(3));
                        langBody.setA5(features.get(4));
                        langBody.setA6(features.get(5));
                        langBody.setA7(features.get(6));
                        langBody.setA8(features.get(7));
                        type = this.randomForest.forest(langBody);
                    }
                    typeList.add(type);
                }
                return typeList;
            }
            throw new Exception("forest is not study");
        }
        throw new Exception("isSplitWord is true");
    }

    private int getDifferentPoint(String word1, String word2) {
        String minWord;
        String maxWord;
        if (word1.length() >= word2.length()) {
            maxWord = word1;
            minWord = word2;
        } else {
            maxWord = word2;
            minWord = word1;
        }
        int times = maxWord.length() - minWord.length();
        boolean isRight = false;
        for (int i = 0; i <= times; ++i) {
            String testWord = maxWord.substring(i, i + minWord.length());
            if (testWord.hashCode() != minWord.hashCode() || !testWord.equals(minWord)) continue;
            isRight = true;
            break;
        }
        if (isRight) {
            return times;
        }
        return -1;
    }

    private int getNub(List<String> words, String testWord) {
        int nub = 0;
        int size = words.size();
        boolean isHere = false;
        for (int i = 0; i < size; ++i) {
            String word = words.get(i);
            if (testWord.hashCode() != word.hashCode() || !testWord.equals(word)) continue;
            isHere = true;
            nub = i + 1;
            break;
        }
        if (!isHere) {
            int minTimes = -1;
            for (int i = 0; i < size; ++i) {
                int times = this.getDifferentPoint(words.get(i), testWord);
                if (times <= 0 || minTimes >= 0 && times >= minTimes) continue;
                minTimes = times;
                nub = i + 1;
            }
        }
        return nub;
    }

    private List<Sentence> catchSentence(String sentence) {
        int len = sentence.length();
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        if (len > 1) {
            for (int j = 0; j < len - 1; ++j) {
                Sentence sentenceWords = new Sentence();
                for (int i = j; i < len; ++i) {
                    String word = sentence.substring(j, i + 1);
                    sentenceWords.setWord(word);
                }
                sentences.add(sentenceWords);
            }
        } else {
            Sentence sentenceWords = new Sentence();
            sentenceWords.setWord(sentence);
            sentences.add(sentenceWords);
        }
        return sentences;
    }

    private void restructure(Sentence words) {
        List<WorldBody> listWord = this.allWorld;
        List<Word> waitWorld = words.getWaitWords();
        for (Word word : waitWorld) {
            String myWord = word.getWord();
            WorldBody body = this.getBody(myWord, listWord);
            if (body == null) {
                word.setWordFrequency(1);
                break;
            }
            listWord = body.getWorldBodies();
            word.setWordFrequency(body.getWordFrequency());
        }
        Tokenizer tokenizer = new Tokenizer(this.wordTemple);
        tokenizer.radiation(words);
    }

    private WorldBody getBody(String word, List<WorldBody> worlds) {
        WorldBody myBody = null;
        for (WorldBody body : worlds) {
            if (body.getWordName().hashCode() != word.hashCode() || !body.getWordName().equals(word)) continue;
            myBody = body;
            break;
        }
        return myBody;
    }
}

