/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wlld.config.TfConfig;
import org.wlld.entity.TalkBody;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;
import org.wlld.naturalLanguage.word.WordBack;
import org.wlld.naturalLanguage.word.WordEmbedding;
import org.wlld.transFormer.TransFormerManager;
import org.wlld.transFormer.model.TransFormerModel;
import org.wlld.transFormer.nerve.SensoryNerve;

public class TalkToTalk
extends MatrixOperation {
    private final WordEmbedding wordEmbedding;
    private final TfConfig tfConfig;
    private final int maxLength;
    private final int times;
    private final String splitWord;
    private TransFormerManager transFormerManager;
    private final boolean splitAnswer;

    public TalkToTalk(WordEmbedding wordEmbedding, TfConfig tfConfig) throws Exception {
        this.splitWord = tfConfig.getSplitWord();
        this.splitAnswer = this.splitWord != null && !this.splitWord.isEmpty();
        this.wordEmbedding = wordEmbedding;
        this.tfConfig = tfConfig;
        this.maxLength = tfConfig.getMaxLength();
        this.times = tfConfig.getTimes();
        if (this.times <= 0) {
            throw new Exception("\u53c2\u6570times\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public void init() throws Exception {
        int wordVectorDimension = this.wordEmbedding.getWordVectorDimension();
        this.tfConfig.setFeatureDimension(wordVectorDimension);
        this.tfConfig.setTypeNumber(this.wordEmbedding.getWordList().size() + 2);
        this.transFormerManager = new TransFormerManager(this.tfConfig);
    }

    private Matrix insertStart(Matrix feature, Matrix lastFeature) throws Exception {
        Matrix matrix = new Matrix(feature.getX() + 1, feature.getY());
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (i > 0) {
                    matrix.setNub(i, j, feature.getNumber(i - 1, j));
                    continue;
                }
                matrix.setNub(i, j, lastFeature.getNumber(0, j));
            }
        }
        return matrix;
    }

    public String getAnswer(String question, long eventID) throws Exception {
        int id;
        SensoryNerve sensoryNerve = this.transFormerManager.getSensoryNerve();
        Matrix qMatrix = this.wordEmbedding.getEmbedding(question, eventID, false).getFeatureMatrix();
        WordBack wordBack = new WordBack();
        StringBuilder answer = new StringBuilder();
        int index = 0;
        ArrayList<String> wordList = new ArrayList<String>();
        do {
            Matrix qcMatrix = qMatrix.copy();
            Matrix allFeatures = this.transFormerManager.getStartMatrix(qMatrix);
            if (!wordList.isEmpty()) {
                for (String word : wordList) {
                    Matrix next = this.wordEmbedding.getEmbedding(word, eventID, true).getFeatureMatrix();
                    allFeatures = this.pushVector(allFeatures, next, true);
                }
            }
            ++index;
            sensoryNerve.postMessage(eventID, qcMatrix, allFeatures, false, null, wordBack, false);
            id = wordBack.getId();
            if (id <= 1) continue;
            String word = this.wordEmbedding.getWord(id - 2);
            wordList.add(word);
            if (this.splitAnswer) {
                word = word + " ";
            }
            answer.append(word);
        } while (id > 1 && index < this.maxLength);
        return answer.toString();
    }

    public void insertModel(TransFormerModel transFormerModel) throws Exception {
        this.transFormerManager.insertModel(transFormerModel);
    }

    private AnswerE getSentenceMatrix(String sentence) throws Exception {
        Matrix allFeature = null;
        AnswerE answerE = new AnswerE();
        ArrayList<Integer> answerList = new ArrayList<Integer>();
        if (this.splitAnswer) {
            String[] words = sentence.split(this.splitWord);
            if (words.length > this.maxLength) {
                words = Arrays.copyOfRange(words, 0, this.maxLength);
            }
            for (String s : words) {
                int wordID = this.wordEmbedding.getID(s) + 2;
                answerList.add(wordID);
            }
            for (String word : words) {
                Matrix feature = this.wordEmbedding.getEmbedding(word, 3L, true).getFeatureMatrix();
                allFeature = allFeature == null ? feature : this.pushVector(allFeature, feature, true);
            }
        } else {
            if (sentence.length() > this.maxLength) {
                sentence = sentence.substring(0, this.maxLength);
            }
            for (int i = 0; i < sentence.length(); ++i) {
                String word = sentence.substring(i, i + 1);
                int wordID = this.wordEmbedding.getID(word) + 2;
                answerList.add(wordID);
            }
            allFeature = this.wordEmbedding.getEmbedding(sentence, 3L, false).getFeatureMatrix();
        }
        answerList.add(1);
        answerE.answerMatrix = allFeature;
        answerE.answerList = answerList;
        return answerE;
    }

    public TransFormerModel study(List<TalkBody> talkBodies) throws Exception {
        SensoryNerve sensoryNerve = this.transFormerManager.getSensoryNerve();
        int size = talkBodies.size();
        for (int k = 0; k < this.times; ++k) {
            int index = 0;
            for (TalkBody talkBody : talkBodies) {
                String question = talkBody.getQuestion();
                String answer = talkBody.getAnswer();
                System.out.println("\u95ee\u9898:" + question + ", \u56de\u7b54:" + answer + ",\u8bad\u7ec3\u8bed\u53e5\u4e0b\u6807:" + ++index + ",\u603b\u6570\u91cf:" + size + ",\u5f53\u524d\u6b21\u6570\uff1a" + k + ",\u603b\u6b21\u6570:" + this.times);
                Matrix qMatrix = this.wordEmbedding.getEmbedding(question, 1L, false).getFeatureMatrix();
                AnswerE answerE = this.getSentenceMatrix(answer);
                Matrix myAnswer = this.insertStart(answerE.answerMatrix, this.transFormerManager.getStartMatrix(qMatrix));
                sensoryNerve.postMessage(1L, qMatrix, myAnswer, true, answerE.answerList, null, false);
            }
        }
        return this.transFormerManager.getModel();
    }

    static class AnswerE {
        List<Integer> answerList;
        Matrix answerMatrix;

        AnswerE() {
        }
    }
}

