/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wlld.entity.WordOfShop;
import org.wlld.naturalLanguage.KeyWord;
import org.wlld.naturalLanguage.LangBody;
import org.wlld.naturalLanguage.Sentence;
import org.wlld.naturalLanguage.Word;
import org.wlld.naturalLanguage.WordConst;
import org.wlld.naturalLanguage.WordTemple;
import org.wlld.naturalLanguage.WorldBody;
import org.wlld.randomForest.DataTable;
import org.wlld.randomForest.RandomForest;
import org.wlld.tools.ArithUtil;
import org.wlld.tools.Frequency;

public class Tokenizer
extends Frequency {
    private List<Sentence> sentences;
    private List<WorldBody> allWorld;
    private List<List<String>> wordTimes;
    private Word nowWord;
    private WordTemple wordTemple;
    private List<WordOfShop> wordOfShopList = new ArrayList<WordOfShop>();

    public List<WordOfShop> getWordOfShopList() {
        return this.wordOfShopList;
    }

    public Tokenizer(WordTemple wordTemple) {
        this.wordTemple = wordTemple;
        this.sentences = wordTemple.getSentences();
        this.allWorld = wordTemple.getAllWorld();
        this.wordTimes = wordTemple.getWordTimes();
    }

    public void start(Map<Integer, List<String>> model) throws Exception {
        for (Map.Entry<Integer, List<String>> mod : model.entrySet()) {
            if (mod.getKey() == 0) continue;
            List<String> st = mod.getValue();
            int key = mod.getKey();
            for (String sentence : st) {
                Sentence sentenceWords = new Sentence(key);
                this.catchSentence(sentence, sentenceWords);
                Word word = sentenceWords.getFirstWord();
                if (word == null) continue;
                this.worldMuch(word, this.allWorld, key);
            }
        }
        this.restructure();
        if (!this.wordTemple.isSplitWord()) {
            this.number();
            this.study();
        } else {
            HashMap<String, WordOfShop> wordOfShopMap = new HashMap<String, WordOfShop>();
            int size = this.sentences.size();
            for (int i = 0; i < size; ++i) {
                Sentence sentence = this.sentences.get(i);
                List<String> keyWords = sentence.getKeyWords();
                int key = sentence.getKey();
                for (String keyWord : keyWords) {
                    WordOfShop wordOfShop;
                    if (wordOfShopMap.containsKey(keyWord)) {
                        wordOfShop = (WordOfShop)wordOfShopMap.get(keyWord);
                        wordOfShop.getShops().add(key);
                        continue;
                    }
                    wordOfShop = new WordOfShop();
                    int index = wordOfShopMap.size() + 1;
                    wordOfShop.setWord(keyWord);
                    wordOfShop.setId(index);
                    wordOfShop.getShops().add(key);
                    wordOfShopMap.put(keyWord, wordOfShop);
                }
            }
            for (Map.Entry entry : wordOfShopMap.entrySet()) {
                this.wordOfShopList.add((WordOfShop)entry.getValue());
            }
        }
    }

    private int getKey(List<String> words, String testWord) {
        int nub = 0;
        int size = words.size();
        for (int i = 0; i < size; ++i) {
            String word = words.get(i);
            if (testWord.hashCode() != word.hashCode() || !testWord.equals(word)) continue;
            nub = i + 1;
            break;
        }
        if (nub == 0) {
            words.add(testWord);
            nub = words.size();
        }
        return nub;
    }

    private void number() {
        System.out.println("\u5f00\u59cb\u7f16\u7801:" + (this.sentences.size() + 1));
        for (Sentence sentence : this.sentences) {
            List<Integer> features = sentence.getFeatures();
            List<String> sentenceList = sentence.getKeyWords();
            int size = sentenceList.size();
            for (int i = 0; i < size; ++i) {
                if (this.wordTimes.size() < i + 1) {
                    this.wordTimes.add(new ArrayList());
                }
                String word = sentenceList.get(i);
                List<String> list = this.wordTimes.get(i);
                int nub = this.getKey(list, word);
                features.add(nub);
            }
        }
    }

    private void study() throws Exception {
        HashSet<String> column = new HashSet<String>();
        for (int i = 0; i < 8; ++i) {
            int t = i + 1;
            column.add("a" + t);
        }
        column.add("key");
        DataTable dataTable = new DataTable(column);
        dataTable.setKey("key");
        RandomForest randomForest = new RandomForest(this.wordTemple.getTreeNub());
        randomForest.setTrustTh(this.wordTemple.getTrustTh());
        randomForest.setTrustPunishment(this.wordTemple.getTrustPunishment());
        this.wordTemple.setRandomForest(randomForest);
        randomForest.init(dataTable);
        for (Sentence sentence : this.sentences) {
            LangBody langBody = new LangBody();
            List<Integer> features = sentence.getFeatures();
            langBody.setKey(sentence.getKey());
            block12: for (int i = 0; i < 8; ++i) {
                int nub = 0;
                if (features.size() > i) {
                    nub = features.get(i);
                }
                int t = i + 1;
                switch (t) {
                    case 1: {
                        langBody.setA1(nub);
                        continue block12;
                    }
                    case 2: {
                        langBody.setA2(nub);
                        continue block12;
                    }
                    case 3: {
                        langBody.setA3(nub);
                        continue block12;
                    }
                    case 4: {
                        langBody.setA4(nub);
                        continue block12;
                    }
                    case 5: {
                        langBody.setA5(nub);
                        continue block12;
                    }
                    case 6: {
                        langBody.setA6(nub);
                        continue block12;
                    }
                    case 7: {
                        langBody.setA7(nub);
                        continue block12;
                    }
                    case 8: {
                        langBody.setA8(nub);
                    }
                }
            }
            randomForest.insert(langBody);
        }
        randomForest.study();
    }

    private void restructure() {
        for (Sentence words : this.sentences) {
            List<WorldBody> listWord = this.allWorld;
            List<Word> waitWorld = words.getWaitWords();
            for (Word word : waitWorld) {
                String myWord = word.getWord();
                WorldBody body = this.getBody(myWord, listWord);
                listWord = body.getWorldBodies();
                word.setWordFrequency(body.getWordFrequency());
            }
        }
        for (Sentence words : this.sentences) {
            this.radiation(words);
        }
    }

    public void radiation(Sentence sentenceWords) {
        this.nowWord = null;
        Word firstWord = sentenceWords.getFirstWord();
        KeyWord word = new KeyWord();
        word.setWord(firstWord);
        word.setOk(false);
        ArrayList<String> keyWords = new ArrayList<String>();
        while (word.getWord() != null) {
            word = this.keyWord(-1.0, word, new double[]{firstWord.getWordFrequency()});
            Word myWord = word.getWord();
            String wordT = myWord.getWord();
            String keyWord = this.nowWord == null ? wordT : wordT.substring(this.nowWord.getWord().length());
            keyWords.add(keyWord);
            this.nowWord = myWord;
            word.setOk(false);
            word.setWord(word.getWord().getSon());
        }
        sentenceWords.setKeyWords(keyWords);
    }

    private double[] getDiff(double[] diff, Word word) {
        double[] diffef = new double[diff.length + 1];
        for (int i = 0; i < diffef.length; ++i) {
            diffef[i] = i == diffef.length - 1 ? (double)word.getWordFrequency() : diff[i];
        }
        return diffef;
    }

    private KeyWord keyWord(double dm, KeyWord words, double[] diff) {
        double right = 0.0;
        boolean bm = words.isOk();
        if (!bm) {
            Word word = words.getWord();
            if (word.getSon() != null) {
                boolean isAvgOk;
                double db = this.wordEnd(word, new ArrayList<Integer>(), 0.0);
                boolean bl = isAvgOk = ArithUtil.mul(word.getWordFrequency() - word.getSon().getWordFrequency(), WordConst.Word_Noise) <= db;
                if (isAvgOk) {
                    diff = this.getDiff(diff, word.getSon());
                    right = this.dc(diff);
                    if (dm > -1.0) {
                        if (ArithUtil.mul(right, WordConst.Word_Noise) <= dm) {
                            words.setOk(false);
                            words.setWord(word.getSon());
                            words = this.keyWord(right, words, diff);
                        } else {
                            words.setOk(true);
                        }
                    } else {
                        words.setOk(false);
                        words.setWord(word.getSon());
                        words = this.keyWord(right, words, diff);
                    }
                } else {
                    words.setOk(true);
                }
            } else {
                words.setOk(true);
            }
        }
        return words;
    }

    private double wordEnd(Word word, List<Integer> av, double a) {
        Word son = word.getSon();
        if (son != null) {
            av.add(word.getWordFrequency() - son.getWordFrequency());
            a = this.wordEnd(son, av, a);
        } else {
            double[] allNub = new double[av.size()];
            for (int i = 0; i < av.size(); ++i) {
                allNub[i] = av.get(i).intValue();
            }
            a = this.average(allNub);
        }
        return a;
    }

    private WorldBody getBody(String word, List<WorldBody> worlds) {
        WorldBody myBody = null;
        for (WorldBody body : worlds) {
            if (body.getWordName().hashCode() != word.hashCode() || !body.getWordName().equals(word)) continue;
            myBody = body;
            break;
        }
        return myBody;
    }

    private void catchSentence(String sentence, Sentence sentenceWords) {
        int len = sentence.length();
        for (int i = 0; i < len; ++i) {
            String word = sentence.substring(0, i + 1);
            sentenceWords.setWord(word);
        }
        this.sentences.add(sentenceWords);
    }

    private void worldMuch(Word word, List<WorldBody> worldBodies, int type) {
        boolean bm = false;
        String check = word.getWord();
        for (WorldBody myWorld : worldBodies) {
            String waitCheck = myWorld.getWordName();
            if (waitCheck.hashCode() != check.hashCode() || !waitCheck.equals(check)) continue;
            bm = true;
            myWorld.addNub(type);
            if (word.getSon() == null) break;
            this.worldMuch(word.getSon(), myWorld.getWorldBodies(), type);
            break;
        }
        if (!bm) {
            this.saveList(word, worldBodies, type);
        }
    }

    private void saveList(Word word, List<WorldBody> myWorld, int type) {
        WorldBody body = new WorldBody();
        ArrayList<WorldBody> list = new ArrayList<WorldBody>();
        body.setWordName(word.getWord());
        body.addNub(type);
        body.setWorldBodies(list);
        body.setWord(word);
        myWorld.add(body);
        if (word.getSon() != null) {
            this.saveList(word.getSon(), list, type);
        }
    }
}

