/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.pso;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.wlld.i.PsoFunction;

public class PSO {
    private double globalValue = -1.0;
    private int times;
    private List<Particle> allPar = new ArrayList<Particle>();
    private PsoFunction psoFunction;
    private double inertialFactor = 0.5;
    private double selfStudyFactor = 2.0;
    private double socialStudyFactor = 2.0;
    private boolean isMax;
    private double[] allBest;
    private Random random = new Random();
    private double[] minBorder;
    private double[] maxBorder;
    private double maxSpeed;
    private double initSpeed;

    public PSO(int dimensionNub, double[] minBorder, double[] maxBorder, int times, int particleNub, PsoFunction psoFunction, double inertialFactor, double selfStudyFactor, double socialStudyFactor, boolean isMax, double maxSpeed, double initSpeed) {
        this.initSpeed = initSpeed;
        this.times = times;
        this.psoFunction = psoFunction;
        this.isMax = isMax;
        this.allBest = new double[dimensionNub];
        this.minBorder = minBorder;
        this.maxBorder = maxBorder;
        this.maxSpeed = maxSpeed;
        if (inertialFactor > 0.0) {
            this.inertialFactor = inertialFactor;
        }
        if (selfStudyFactor >= 0.0 && selfStudyFactor <= 4.0) {
            this.selfStudyFactor = selfStudyFactor;
        }
        if (socialStudyFactor >= 0.0 && socialStudyFactor <= 4.0) {
            this.socialStudyFactor = socialStudyFactor;
        }
        for (int i = 0; i < particleNub; ++i) {
            Particle particle = new Particle(dimensionNub);
            this.allPar.add(particle);
        }
    }

    public double[] getAllBest() {
        return this.allBest;
    }

    public void setAllPar(List<Particle> allPar) {
        this.allPar = allPar;
    }

    public void start() throws Exception {
        int size = this.allPar.size();
        for (int i = 0; i < this.times; ++i) {
            for (int j = 0; j < size; ++j) {
                this.move(this.allPar.get(j), j);
            }
        }
    }

    private void move(Particle particle, int id) throws Exception {
        int i;
        double[] parameter = particle.getParameter();
        BestData[] bestData = particle.bestDataArray;
        double value = this.psoFunction.getResult(parameter, id);
        double selfValue = particle.selfBestValue;
        if (this.isMax) {
            if (value > this.globalValue) {
                this.globalValue = value;
                for (i = 0; i < this.allBest.length; ++i) {
                    this.allBest[i] = parameter[i];
                }
            }
            if (value > selfValue) {
                particle.selfBestValue = value;
                for (i = 0; i < bestData.length; ++i) {
                    bestData[i].selfBestPosition = parameter[i];
                }
            }
        } else {
            if (this.globalValue < 0.0 || value < this.globalValue) {
                this.globalValue = value;
                for (i = 0; i < this.allBest.length; ++i) {
                    this.allBest[i] = parameter[i];
                }
            }
            if (selfValue < 0.0 || value < selfValue) {
                particle.selfBestValue = value;
                for (i = 0; i < bestData.length; ++i) {
                    bestData[i].selfBestPosition = parameter[i];
                }
            }
        }
        for (i = 0; i < bestData.length; ++i) {
            double speed = bestData[i].speed;
            double pid = bestData[i].selfBestPosition;
            double selfPosition = parameter[i];
            double pgd = this.allBest[i];
            if (Math.abs(speed = this.inertialFactor * speed + this.selfStudyFactor * this.random.nextDouble() * (pid - selfPosition) + this.socialStudyFactor * this.random.nextDouble() * (pgd - selfPosition)) > this.maxSpeed) {
                speed = speed > 0.0 ? this.maxSpeed : -this.maxSpeed;
            }
            bestData[i].speed = speed;
            double position = selfPosition + speed;
            if (this.minBorder != null) {
                if (position < this.minBorder[i]) {
                    position = this.minBorder[i];
                }
                if (position > this.maxBorder[i]) {
                    position = this.maxBorder[i];
                }
            }
            bestData[i].selfPosition = position;
        }
    }

    class Particle {
        private BestData[] bestDataArray;
        private double selfBestValue = -1.0;

        private double[] getParameter() {
            double[] parameter = new double[this.bestDataArray.length];
            for (int i = 0; i < parameter.length; ++i) {
                parameter[i] = this.bestDataArray[i].selfPosition;
            }
            return parameter;
        }

        protected Particle(int dimensionNub) {
            this.bestDataArray = new BestData[dimensionNub];
            for (int i = 0; i < dimensionNub; ++i) {
                double position;
                if (PSO.this.minBorder != null && PSO.this.maxBorder != null) {
                    double min = PSO.this.minBorder[i];
                    double max = PSO.this.maxBorder[i];
                    double region = max - min + 1.0;
                    position = (double)PSO.this.random.nextInt((int)region) + min;
                } else {
                    position = PSO.this.random.nextDouble();
                }
                this.bestDataArray[i] = new BestData(position, PSO.this.initSpeed);
            }
        }
    }

    class BestData {
        private double speed;
        private double selfBestPosition;
        private double selfPosition;

        private BestData(double selfPosition, double initSpeed) {
            this.selfBestPosition = selfPosition;
            this.selfPosition = selfPosition;
            this.speed = initSpeed;
        }
    }
}

