/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.rnnJumpNerveEntity;

import java.util.List;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;
import org.wlld.naturalLanguage.word.WordEmbedding;
import org.wlld.rnnJumpNerveEntity.Nerve;

public class NerveCenter
extends MatrixOperation {
    private final int depth;
    private final double powerTh;
    private final List<Nerve> nerveList;
    private WordEmbedding wordEmbedding;
    private final boolean isFinish;

    public int getDepth() {
        return this.depth;
    }

    public NerveCenter(int depth, List<Nerve> nerveList, double powerTh, boolean isFinish) {
        this.depth = depth;
        this.nerveList = nerveList;
        this.powerTh = powerTh;
        this.isFinish = isFinish;
    }

    public void setWordEmbedding(WordEmbedding wordEmbedding) {
        this.wordEmbedding = wordEmbedding;
    }

    public void backType(long eventId, double parameter, int id, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        if (id > 0 && parameter > this.powerTh) {
            String nextWord = this.wordEmbedding.getWord(id - 1);
            myWord = myWord == null ? nextWord : myWord + nextWord;
            if (this.isFinish) {
                outBack.backWord(myWord, eventId);
            } else {
                Matrix matrix = this.wordEmbedding.getEmbedding(nextWord, eventId, false).getFeatureMatrix();
                featureMatrix = this.pushVector(featureMatrix, matrix, true);
                this.go(eventId, featureMatrix, outBack, myWord);
            }
        } else {
            outBack.backWord(myWord, eventId);
        }
    }

    private void go(long eventId, Matrix featureMatrix, OutBack outBack, String word) throws Exception {
        for (Nerve nerve : this.nerveList) {
            nerve.sendMyTestMessage(eventId, featureMatrix, outBack, word);
        }
    }
}

