/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.rnnNerveEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.wlld.i.ActiveFunction;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;

public abstract class Nerve {
    private final List<Nerve> son = new ArrayList<Nerve>();
    private final List<Nerve> rnnOut = new ArrayList<Nerve>();
    private final List<Nerve> father = new ArrayList<Nerve>();
    protected Map<Integer, Double> dendrites = new HashMap<Integer, Double>();
    protected Map<Integer, Double> wg = new HashMap<Integer, Double>();
    private final int id;
    boolean fromOutNerve = false;
    protected int upNub;
    protected int downNub;
    protected int rnnOutNub;
    protected Map<Long, List<Double>> features = new HashMap<Long, List<Double>>();
    protected Matrix nerveMatrix;
    protected double threshold;
    protected String name;
    protected double outNub;
    protected double E;
    protected double gradient;
    protected double studyPoint;
    protected double sigmaW;
    private int backNub = 0;
    protected ActiveFunction activeFunction;
    private final int rzType;
    private final double lParam;
    private final int step;
    private final int kernLen;
    private Matrix im2col;
    private int xInput;
    private int yInput;
    private Matrix outMatrix;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public Map<Integer, Double> getDendrites() {
        return this.dendrites;
    }

    public Matrix getNerveMatrix() {
        return this.nerveMatrix;
    }

    public void setNerveMatrix(Matrix nerveMatrix) {
        this.nerveMatrix = nerveMatrix;
    }

    public void setDendrites(Map<Integer, Double> dendrites) {
        this.dendrites = dendrites;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    protected Nerve(int id, int upNub, String name, int downNub, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, double lParam, int step, int kernLen, int rnnOutNub) throws Exception {
        this.id = id;
        this.upNub = upNub;
        this.name = name;
        this.downNub = downNub;
        this.studyPoint = studyPoint;
        this.activeFunction = activeFunction;
        this.rzType = rzType;
        this.lParam = lParam;
        this.step = step;
        this.kernLen = kernLen;
        this.rnnOutNub = rnnOutNub;
        if (name.equals("OutNerve")) {
            this.fromOutNerve = true;
        }
        this.initPower(init, isDynamic);
    }

    protected void setStudyPoint(double studyPoint) {
        this.studyPoint = studyPoint;
    }

    public void sendMessage(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, boolean isEmbedding, Matrix rnnMatrix) throws Exception {
        if (this.son.size() > 0) {
            for (Nerve nerve : this.son) {
                nerve.input(eventId, parameter, isStudy, E, outBack, isEmbedding, rnnMatrix);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    public void sendRnnMessage(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, boolean isEmbedding, Matrix rnnMatrix) throws Exception {
        if (this.rnnOut.size() > 0) {
            for (Nerve nerve : this.rnnOut) {
                nerve.input(eventId, parameter, isStudy, E, outBack, isEmbedding, rnnMatrix);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    protected Matrix conv(Matrix matrix) throws Exception {
        this.xInput = matrix.getX();
        this.yInput = matrix.getY();
        int sub = this.kernLen - this.step;
        int x = (this.xInput - sub) / this.step;
        int y = (this.yInput - sub) / this.step;
        Matrix myMatrix = new Matrix(x, y);
        this.im2col = this.matrixOperation.im2col(matrix, this.kernLen, this.step);
        Matrix matrixOut = this.matrixOperation.mulMatrix(this.im2col, this.nerveMatrix);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                double nub = this.activeFunction.function(matrixOut.getNumber(i * y + j, 0));
                myMatrix.setNub(i, j, nub);
            }
        }
        this.outMatrix = myMatrix;
        return myMatrix;
    }

    public void sendMatrix(long eventId, Matrix parameter, boolean isStudy, int E, OutBack outBack) throws Exception {
        if (this.son.size() > 0) {
            for (Nerve nerve : this.son) {
                nerve.inputMatrix(eventId, parameter, isStudy, E, outBack);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    private void backSendMessage(long eventId, boolean fromOutNerve) throws Exception {
        if (this.father.size() > 0) {
            for (int i = 0; i < this.father.size(); ++i) {
                this.father.get(i).backGetMessage(this.wg.get(i + 1), eventId, fromOutNerve);
            }
        }
    }

    private void backMatrixMessage(Matrix g) throws Exception {
        if (this.father.size() > 0) {
            for (int i = 0; i < this.father.size(); ++i) {
                this.father.get(i).backMatrix(g);
            }
        }
    }

    protected void input(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack imageBack, boolean isEmbedding, Matrix rnnMatrix) throws Exception {
    }

    protected void inputMatrix(long eventId, Matrix matrix, boolean isKernelStudy, int E, OutBack outBack) throws Exception {
    }

    private void backGetMessage(double parameter, long eventId, boolean fromOutNerve) throws Exception {
        ++this.backNub;
        this.sigmaW += parameter;
        int number = fromOutNerve ? this.rnnOutNub : this.downNub;
        if (this.backNub == number) {
            this.backNub = 0;
            this.gradient = this.activeFunction.functionG(this.outNub) * this.sigmaW;
            this.updatePower(eventId);
        }
    }

    protected void backMatrix(Matrix g) throws Exception {
        int x = g.getX();
        int y = g.getY();
        Matrix yc = new Matrix(x * y, 1);
        int index = 0;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                double error = g.getNumber(i, j);
                double out = this.outMatrix.getNumber(i, j);
                error = error * this.activeFunction.functionG(out) * this.studyPoint;
                yc.setNub(index, 0, error);
                ++index;
            }
        }
        Matrix trx = this.matrixOperation.transPosition(this.im2col);
        Matrix wSub = this.matrixOperation.mulMatrix(trx, yc);
        x = this.im2col.getX();
        y = this.im2col.getY() - 1;
        for (int i = 0; i < x; ++i) {
            double ySub = yc.getNumber(i, 0);
            for (int j = 0; j < y; ++j) {
                double k = this.nerveMatrix.getNumber(j, 0) * ySub;
                this.im2col.setNub(i, j, k);
            }
        }
        Matrix gNext = this.matrixOperation.reverseIm2col(this.im2col, this.kernLen, this.step, this.xInput, this.yInput);
        this.nerveMatrix = this.matrixOperation.add(this.nerveMatrix, wSub);
        this.backMatrixMessage(gNext);
    }

    protected void updatePower(long eventId) throws Exception {
        double h = this.gradient * this.studyPoint;
        this.threshold -= h;
        this.updateW(h, eventId);
        this.sigmaW = 0.0;
        this.backSendMessage(eventId, this.fromOutNerve);
    }

    private double regularization(double w, double param) {
        double re = 0.0;
        if (this.rzType != 0) {
            if (this.rzType == 2) {
                re = param * -w;
            } else if (this.rzType == 1) {
                if (w > 0.0) {
                    re = -param;
                } else if (w < 0.0) {
                    re = param;
                }
            }
        }
        return re;
    }

    private void updateW(double h, long eventId) {
        List<Double> list = this.features.get(eventId);
        double param = 0.0;
        if (this.rzType != 0) {
            double sigma = 0.0;
            for (Map.Entry<Integer, Double> entry : this.dendrites.entrySet()) {
                if (this.rzType == 2) {
                    sigma += Math.pow(entry.getValue(), 2.0);
                    continue;
                }
                sigma += Math.abs(entry.getValue());
            }
            param = sigma * this.lParam * this.studyPoint;
        }
        for (Map.Entry<Integer, Double> entry : this.dendrites.entrySet()) {
            int key = entry.getKey();
            double w = entry.getValue();
            double bn = list.get(key - 1);
            double wp = bn * h;
            double dm = w * this.gradient;
            double regular = this.regularization(w, param);
            w += regular;
            this.wg.put(key, dm);
            this.dendrites.put(key, w += wp);
        }
        this.features.remove(eventId);
    }

    protected boolean insertParameter(long eventId, double parameter) {
        List<Object> featuresList;
        boolean allReady = false;
        if (this.features.containsKey(eventId)) {
            featuresList = this.features.get(eventId);
        } else {
            featuresList = new ArrayList();
            this.features.put(eventId, featuresList);
        }
        featuresList.add(parameter);
        if (featuresList.size() >= this.upNub) {
            allReady = true;
        }
        return allReady;
    }

    protected void destoryParameter(long eventId) {
        this.features.remove(eventId);
    }

    protected double getWOne(long eventId) {
        List<Double> featuresList = this.features.get(eventId);
        double wt = 0.0;
        for (int i = 0; i < featuresList.size(); ++i) {
            double value = featuresList.get(i);
            double w = this.dendrites.get(i + 1);
            if (!(value > 0.5)) continue;
            wt = w;
            break;
        }
        return wt;
    }

    protected double calculation(long eventId) {
        double sigma = 0.0;
        List<Double> featuresList = this.features.get(eventId);
        for (int i = 0; i < featuresList.size(); ++i) {
            double value = featuresList.get(i);
            double w = this.dendrites.get(i + 1);
            sigma = w * value + sigma;
        }
        return sigma - this.threshold;
    }

    private void initPower(boolean init, boolean isDynamic) throws Exception {
        Random random = new Random();
        if (!isDynamic) {
            if (this.upNub > 0) {
                double sh = Math.sqrt(this.upNub);
                for (int i = 1; i < this.upNub + 1; ++i) {
                    double nub = 0.0;
                    if (init) {
                        nub = random.nextDouble() / sh;
                    }
                    this.dendrites.put(i, nub);
                }
                double nub = 0.0;
                if (init) {
                    nub = random.nextDouble() / sh;
                }
                this.threshold = nub;
            }
        } else {
            int nerveNub = this.kernLen * this.kernLen;
            double sh = Math.sqrt(2.0 / (double)nerveNub);
            this.nerveMatrix = new Matrix(nerveNub + 1, 1);
            for (int i = 0; i < this.nerveMatrix.getX(); ++i) {
                double nub = 0.0;
                if (init) {
                    nub = random.nextDouble() * sh;
                }
                this.nerveMatrix.setNub(i, 0, nub);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void connect(List<Nerve> nerveList) {
        this.son.addAll(nerveList);
    }

    public void connectOut(List<Nerve> nerveList) {
        this.rnnOut.addAll(nerveList);
    }

    public void connectFather(List<Nerve> nerveList) {
        this.father.addAll(nerveList);
    }
}

