/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage;

import java.util.ArrayList;
import java.util.List;
import org.wlld.naturalLanguage.Sentence;
import org.wlld.naturalLanguage.Tokenizer;
import org.wlld.naturalLanguage.Word;
import org.wlld.naturalLanguage.WordTemple;
import org.wlld.naturalLanguage.WorldBody;

public class Talk {
    private final List<WorldBody> allWorld;
    private final WordTemple wordTemple;

    public Talk(WordTemple wordTemple) {
        this.wordTemple = wordTemple;
        this.allWorld = wordTemple.getAllWorld();
    }

    public List<List<String>> getSplitWord(String sentence) {
        List<Sentence> sentences = this.splitSentence(sentence);
        ArrayList<List<String>> words = new ArrayList<List<String>>();
        for (Sentence sentence1 : sentences) {
            words.add(sentence1.getKeyWords());
        }
        return words;
    }

    private List<Sentence> splitSentence(String sentence) {
        String[] sens = sentence.replace(" ", "").split("\uff0c|\u3002|\uff1f|\uff01|\uff1b|\u3001|\uff1a");
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        for (String mySentence : sens) {
            List<Sentence> sentenceList = this.catchSentence(mySentence);
            int key = 0;
            int nub = 0;
            for (int j = 0; j < sentenceList.size(); ++j) {
                Sentence sentence1 = sentenceList.get(j);
                this.restructure(sentence1);
                int size = sentence1.getKeyWords().size();
                if (size <= nub) continue;
                key = j;
                nub = size;
            }
            sentences.add(sentenceList.get(key));
        }
        return sentences;
    }

    private List<Sentence> catchSentence(String sentence) {
        int len = sentence.length();
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        if (len > 1) {
            for (int j = 0; j < len - 1; ++j) {
                Sentence sentenceWords = new Sentence();
                for (int i = j; i < len; ++i) {
                    String word = sentence.substring(j, i + 1);
                    sentenceWords.setWord(word);
                }
                sentences.add(sentenceWords);
            }
        } else {
            Sentence sentenceWords = new Sentence();
            sentenceWords.setWord(sentence);
            sentences.add(sentenceWords);
        }
        return sentences;
    }

    private void restructure(Sentence words) {
        List<WorldBody> listWord = this.allWorld;
        List<Word> waitWorld = words.getWaitWords();
        for (Word word : waitWorld) {
            String myWord = word.getWord();
            WorldBody body = this.getBody(myWord, listWord);
            if (body == null) {
                word.setWordFrequency(1);
                break;
            }
            listWord = body.getWorldBodies();
            word.setWordFrequency(body.getWordFrequency());
        }
        Tokenizer tokenizer = new Tokenizer(this.wordTemple);
        tokenizer.radiation(words);
    }

    private WorldBody getBody(String word, List<WorldBody> worlds) {
        WorldBody myBody = null;
        for (WorldBody body : worlds) {
            if (body.getWordName().hashCode() != word.hashCode() || !body.getWordName().equals(word)) continue;
            myBody = body;
            break;
        }
        return myBody;
    }
}

