/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage;

import java.util.ArrayList;
import java.util.List;
import org.wlld.naturalLanguage.KeyWord;
import org.wlld.naturalLanguage.Sentence;
import org.wlld.naturalLanguage.Word;
import org.wlld.naturalLanguage.WordTemple;
import org.wlld.naturalLanguage.WorldBody;
import org.wlld.tools.ArithUtil;
import org.wlld.tools.Frequency;

public class Tokenizer
extends Frequency {
    private final List<Sentence> sentences;
    private final List<WorldBody> allWorld;
    private final double wordNoise;

    public Tokenizer(WordTemple wordTemple) {
        this.sentences = wordTemple.getSentences();
        this.allWorld = wordTemple.getAllWorld();
        this.wordNoise = wordTemple.getWordNoise();
    }

    public void start(List<String> st) throws Exception {
        for (String sentence : st) {
            Sentence sentenceWords = new Sentence();
            this.catchSentence(sentence, sentenceWords);
            Word word = sentenceWords.getFirstWord();
            if (word == null) continue;
            this.worldMuch(word, this.allWorld);
        }
        this.restructure();
    }

    private void restructure() {
        for (Sentence words : this.sentences) {
            List<WorldBody> listWord = this.allWorld;
            List<Word> waitWorld = words.getWaitWords();
            for (Word word : waitWorld) {
                String myWord = word.getWord();
                WorldBody body = this.getBody(myWord, listWord);
                listWord = body.getWorldBodies();
                word.setWordFrequency(body.getWordFrequency());
            }
        }
        for (Sentence words : this.sentences) {
            this.radiation(words);
        }
    }

    public void radiation(Sentence sentenceWords) {
        Word nowWord = null;
        Word firstWord = sentenceWords.getFirstWord();
        KeyWord word = new KeyWord();
        word.setWord(firstWord);
        word.setOk(false);
        ArrayList<String> keyWords = new ArrayList<String>();
        while (word.getWord() != null) {
            word = this.keyWord(-1.0, word, new double[]{firstWord.getWordFrequency()});
            Word myWord = word.getWord();
            String wordT = myWord.getWord();
            String keyWord = nowWord == null ? wordT : wordT.substring(nowWord.getWord().length());
            keyWords.add(keyWord);
            nowWord = myWord;
            word.setOk(false);
            word.setWord(word.getWord().getSon());
        }
        sentenceWords.setKeyWords(keyWords);
    }

    private double[] getDiff(double[] diff, Word word) {
        double[] diffef = new double[diff.length + 1];
        for (int i = 0; i < diffef.length; ++i) {
            diffef[i] = i == diffef.length - 1 ? (double)word.getWordFrequency() : diff[i];
        }
        return diffef;
    }

    private KeyWord keyWord(double dm, KeyWord words, double[] diff) {
        double right = 0.0;
        boolean bm = words.isOk();
        if (!bm) {
            Word word = words.getWord();
            if (word.getSon() != null) {
                boolean isAvgOk;
                double db = this.wordEnd(word, new ArrayList<Integer>(), 0.0);
                boolean bl = isAvgOk = ArithUtil.mul(word.getWordFrequency() - word.getSon().getWordFrequency(), this.wordNoise) <= db;
                if (isAvgOk) {
                    diff = this.getDiff(diff, word.getSon());
                    right = this.dc(diff);
                    if (dm > -1.0) {
                        if (ArithUtil.mul(right, this.wordNoise) <= dm) {
                            words.setOk(false);
                            words.setWord(word.getSon());
                            words = this.keyWord(right, words, diff);
                        } else {
                            words.setOk(true);
                        }
                    } else {
                        words.setOk(false);
                        words.setWord(word.getSon());
                        words = this.keyWord(right, words, diff);
                    }
                } else {
                    words.setOk(true);
                }
            } else {
                words.setOk(true);
            }
        }
        return words;
    }

    private double wordEnd(Word word, List<Integer> av, double a) {
        Word son = word.getSon();
        if (son != null) {
            av.add(word.getWordFrequency() - son.getWordFrequency());
            a = this.wordEnd(son, av, a);
        } else {
            double[] allNub = new double[av.size()];
            for (int i = 0; i < av.size(); ++i) {
                allNub[i] = av.get(i).intValue();
            }
            a = this.average(allNub);
        }
        return a;
    }

    private WorldBody getBody(String word, List<WorldBody> worlds) {
        WorldBody myBody = null;
        for (WorldBody body : worlds) {
            if (body.getWordName().hashCode() != word.hashCode() || !body.getWordName().equals(word)) continue;
            myBody = body;
            break;
        }
        return myBody;
    }

    private void catchSentence(String sentence, Sentence sentenceWords) {
        int len = sentence.length();
        for (int i = 0; i < len; ++i) {
            String word = sentence.substring(0, i + 1);
            sentenceWords.setWord(word);
        }
        this.sentences.add(sentenceWords);
    }

    private void worldMuch(Word word, List<WorldBody> worldBodies) {
        boolean bm = false;
        String check = word.getWord();
        for (WorldBody myWorld : worldBodies) {
            String waitCheck = myWorld.getWordName();
            if (waitCheck.hashCode() != check.hashCode() || !waitCheck.equals(check)) continue;
            bm = true;
            myWorld.addNub();
            if (word.getSon() == null) break;
            this.worldMuch(word.getSon(), myWorld.getWorldBodies());
            break;
        }
        if (!bm) {
            this.saveList(word, worldBodies);
        }
    }

    private void saveList(Word word, List<WorldBody> myWorld) {
        WorldBody body = new WorldBody();
        ArrayList<WorldBody> list = new ArrayList<WorldBody>();
        body.setWordName(word.getWord());
        body.addNub();
        body.setWorldBodies(list);
        body.setWord(word);
        myWorld.add(body);
        if (word.getSon() != null) {
            this.saveList(word.getSon(), list);
        }
    }
}

