/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.regressionForest;

import java.util.Arrays;
import java.util.Map;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;
import org.wlld.tools.Frequency;

public class Forest
extends Frequency {
    private Matrix conditionMatrix;
    private Matrix resultMatrix;
    private Forest forestLeft;
    private Forest forestRight;
    private int featureSize;
    private double resultVariance;
    private double median;
    private double shrinkParameter;
    private Matrix pc;
    private Matrix pc1;
    private double[] w;
    private boolean isOldG = true;
    private int oldGId = 0;
    private Matrix matrixAll;
    private double gNorm;
    private Forest father;
    private final Map<Integer, Forest> forestMap;
    private int id;
    private boolean isRemove = false;
    private boolean notRemovable = false;
    private final int minGrain;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public Forest(int featureSize, double shrinkParameter, Matrix pc, Map<Integer, Forest> forestMap, int id, int minGrain) {
        this.featureSize = featureSize;
        this.shrinkParameter = shrinkParameter;
        this.pc = pc;
        this.w = new double[featureSize];
        this.forestMap = forestMap;
        this.id = id;
        this.minGrain = minGrain;
    }

    public double getMedian() {
        return this.median;
    }

    public double getResultVariance() {
        return this.resultVariance;
    }

    public void setResultVariance(double resultVariance) {
        this.resultVariance = resultVariance;
    }

    public double getMappingFeature(Matrix feature) throws Exception {
        double nub;
        if (feature.isRowVector()) {
            nub = this.isOldG ? feature.getNumber(0, this.oldGId) : this.transG(this.pc1, feature, this.gNorm);
        } else {
            throw new Exception("feature is not a rowVector");
        }
        return nub;
    }

    private double[] findG() throws Exception {
        int xSize = this.conditionMatrix.getX();
        int ySize = this.conditionMatrix.getY();
        this.matrixAll = new Matrix(xSize, ySize);
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                if (j < ySize - 1) {
                    this.matrixAll.setNub(i, j, this.conditionMatrix.getNumber(i, j));
                    continue;
                }
                this.matrixAll.setNub(i, j, this.resultMatrix.getNumber(i, 0));
            }
        }
        double maxOld = 0.0;
        int type = 0;
        for (int i = 0; i < this.featureSize; ++i) {
            double[] g = new double[this.conditionMatrix.getX()];
            for (int j = 0; j < g.length; ++j) {
                g[j] = i < this.featureSize - 1 ? this.conditionMatrix.getNumber(j, i) : this.resultMatrix.getNumber(j, 0);
            }
            double var = this.dc(g);
            if (!(var > maxOld)) continue;
            maxOld = var;
            type = i;
        }
        int x = this.pc.getX();
        double max = 0.0;
        for (int i = 0; i < x; ++i) {
            Matrix g = this.pc.getRow(i);
            double gNorm = this.matrixOperation.getNorm(g);
            double[] var = new double[xSize];
            for (int j = 0; j < xSize; ++j) {
                double dist;
                Matrix parameter = this.matrixAll.getRow(j);
                var[j] = dist = this.transG(g, parameter, gNorm);
            }
            double variance = this.dc(var);
            if (!(variance > max)) continue;
            max = variance;
            this.pc1 = g;
        }
        if (max > maxOld) {
            this.isOldG = false;
        } else {
            this.isOldG = true;
            this.oldGId = type;
        }
        return this.findTwo(xSize);
    }

    private double transG(Matrix g, Matrix parameter, double gNorm) throws Exception {
        double innerProduct = this.matrixOperation.innerProduct(g, parameter);
        return innerProduct / gNorm;
    }

    private double[] findTwo(int dataSize) throws Exception {
        double[] data = new double[dataSize];
        if (this.isOldG) {
            Matrix matrix = this.oldGId == this.featureSize - 1 ? this.resultMatrix : this.conditionMatrix.getColumn(this.oldGId);
            for (int i = 0; i < dataSize; ++i) {
                data[i] = matrix.getNumber(i, 0);
            }
        } else {
            int x = this.matrixAll.getX();
            this.gNorm = this.matrixOperation.getNorm(this.pc1);
            for (int i = 0; i < x; ++i) {
                double dist;
                Matrix parameter = this.matrixAll.getRow(i);
                data[i] = dist = this.transG(this.pc1, parameter, this.gNorm);
            }
        }
        Arrays.sort(data);
        return data;
    }

    private double getDist(double[] data, double[] w) {
        int len = data.length;
        double sigma = 0.0;
        for (int i = 0; i < len; ++i) {
            double sub = data[i] - w[i];
            sigma += Math.pow(sub, 2.0);
        }
        return sigma / (double)len;
    }

    public void pruning() {
        if (!this.notRemovable) {
            Forest fatherForest = this.getFather();
            double[] fatherW = fatherForest.getW();
            double sub = this.getDist(this.w, fatherW);
            if (sub < this.shrinkParameter) {
                fatherForest.getSonMessage(true, this.id);
                this.isRemove = true;
            } else {
                fatherForest.getSonMessage(false, this.id);
            }
        }
    }

    public void getSonMessage(boolean isPruning, int myId) {
        if (isPruning) {
            if (myId == this.id * 2) {
                this.forestLeft = null;
            } else {
                this.forestRight = null;
            }
        } else {
            this.notRemovable = true;
        }
    }

    public void cut() throws Exception {
        int y = this.resultMatrix.getX();
        if (y > this.minGrain) {
            double[] dm = this.findG();
            int z = y / 2;
            this.median = dm[z];
            int rightNub = 0;
            int leftNub = 0;
            for (int i = 0; i < dm.length; ++i) {
                if (dm[i] > this.median) {
                    ++rightNub;
                    continue;
                }
                ++leftNub;
            }
            int leftId = 2 * this.id;
            int rightId = leftId + 1;
            this.forestMap.put(this.id, this);
            this.forestLeft = new Forest(this.featureSize, this.shrinkParameter, this.pc, this.forestMap, leftId, this.minGrain);
            this.forestRight = new Forest(this.featureSize, this.shrinkParameter, this.pc, this.forestMap, rightId, this.minGrain);
            this.forestRight.setFather(this);
            this.forestLeft.setFather(this);
            Matrix conditionMatrixLeft = new Matrix(leftNub, this.featureSize);
            Matrix conditionMatrixRight = new Matrix(rightNub, this.featureSize);
            Matrix resultMatrixLeft = new Matrix(leftNub, 1);
            Matrix resultMatrixRight = new Matrix(rightNub, 1);
            this.forestLeft.setConditionMatrix(conditionMatrixLeft);
            this.forestLeft.setResultMatrix(resultMatrixLeft);
            this.forestRight.setConditionMatrix(conditionMatrixRight);
            this.forestRight.setResultMatrix(resultMatrixRight);
            int leftIndex = 0;
            int rightIndex = 0;
            for (int i = 0; i < y; ++i) {
                int j;
                double nub;
                if (this.isOldG) {
                    nub = this.matrixAll.getNumber(i, this.oldGId);
                } else {
                    Matrix parameter = this.matrixAll.getRow(i);
                    nub = this.transG(this.pc1, parameter, this.gNorm);
                }
                if (nub > this.median) {
                    for (j = 0; j < this.featureSize; ++j) {
                        conditionMatrixRight.setNub(rightIndex, j, this.conditionMatrix.getNumber(i, j));
                    }
                    resultMatrixRight.setNub(rightIndex, 0, this.resultMatrix.getNumber(i, 0));
                    ++rightIndex;
                    continue;
                }
                for (j = 0; j < this.featureSize; ++j) {
                    conditionMatrixLeft.setNub(leftIndex, j, this.conditionMatrix.getNumber(i, j));
                }
                resultMatrixLeft.setNub(leftIndex, 0, this.resultMatrix.getNumber(i, 0));
                ++leftIndex;
            }
        }
    }

    public Matrix getConditionMatrix() {
        return this.conditionMatrix;
    }

    public void setConditionMatrix(Matrix conditionMatrix) {
        this.conditionMatrix = conditionMatrix;
    }

    public Matrix getResultMatrix() {
        return this.resultMatrix;
    }

    public void setResultMatrix(Matrix resultMatrix) {
        this.resultMatrix = resultMatrix;
    }

    public double[] getW() {
        return this.w;
    }

    public void setW(double[] w) {
        this.w = w;
    }

    public Forest getForestLeft() {
        return this.forestLeft;
    }

    public Forest getForestRight() {
        return this.forestRight;
    }

    public Forest getFather() {
        return this.father;
    }

    public void setFather(Forest father) {
        this.father = father;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    public void setRemove(boolean remove) {
        this.isRemove = remove;
    }

    public boolean isNotRemovable() {
        return this.notRemovable;
    }

    public void setNotRemovable(boolean notRemovable) {
        this.notRemovable = notRemovable;
    }
}

