/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.regressionForest;

import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;

public class LinearRegression {
    private double w1;
    private double w2;
    private double b;
    private Matrix XY;
    private Matrix NormSequence;
    private int xIndex = 0;
    private boolean isRegression = false;
    private double avg;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public LinearRegression(int size) {
        this.XY = new Matrix(size, 3);
        this.NormSequence = new Matrix(size, 1);
        this.xIndex = 0;
        this.avg = 0.0;
    }

    public LinearRegression() {
    }

    public void insertXY(double[] xy, double sequence) throws Exception {
        if (xy.length == 2) {
            this.XY.setNub(this.xIndex, 0, xy[0]);
            this.XY.setNub(this.xIndex, 1, xy[1]);
            this.XY.setNub(this.xIndex, 2, 1.0);
            this.NormSequence.setNub(this.xIndex, 0, sequence);
            ++this.xIndex;
        } else {
            throw new Exception("rgb length is not equals three");
        }
    }

    public double getValue(double x, double y) {
        if (this.isRegression) {
            return this.w1 * x + this.w2 * y + this.b;
        }
        return this.avg;
    }

    public double getCos(Matrix vector) throws Exception {
        Matrix matrix = new Matrix(1, 3);
        matrix.setNub(0, 0, this.w1);
        matrix.setNub(0, 1, this.w2);
        matrix.setNub(0, 2, this.b);
        return this.matrixOperation.getNormCos(matrix, vector);
    }

    public void regression() throws Exception {
        if (this.xIndex > 0) {
            Matrix ws = this.matrixOperation.getLinearRegression(this.XY, this.NormSequence);
            if (ws.getX() == 1 && ws.getY() == 1) {
                this.isRegression = false;
                for (int i = 0; i < this.xIndex; ++i) {
                    this.avg += this.NormSequence.getNumber(this.xIndex, 0);
                }
                this.avg /= (double)this.xIndex;
            } else {
                this.w1 = ws.getNumber(0, 0);
                this.w2 = ws.getNumber(1, 0);
                this.b = ws.getNumber(2, 0);
                this.isRegression = true;
            }
        } else {
            throw new Exception("regression matrix size is zero");
        }
    }

    public double getW1() {
        return this.w1;
    }

    public void setW1(double w1) {
        this.w1 = w1;
    }

    public double getW2() {
        return this.w2;
    }

    public void setW2(double w2) {
        this.w2 = w2;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }
}

