/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.rnnNerveEntity;

import java.util.Map;
import org.wlld.i.ActiveFunction;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.rnnNerveEntity.Nerve;

public class HiddenNerve
extends Nerve {
    private int depth;

    public HiddenNerve(int id, int depth, int upNub, int downNub, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, double lParam, int step, int kernLen, int rnnOutNumber) throws Exception {
        super(id, upNub, "HiddenNerve", downNub, studyPoint, init, activeFunction, isDynamic, rzType, lParam, step, kernLen, rnnOutNumber);
        this.depth = depth;
    }

    @Override
    public void input(long eventId, double parameter, boolean isKernelStudy, Map<Integer, Double> E, OutBack outBack, boolean isEmbedding, Matrix rnnMatrix) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            if (isEmbedding) {
                outBack.getWordVector(this.getId(), this.getWOne(eventId));
                this.destoryParameter(eventId);
            } else {
                double sigma = this.calculation(eventId);
                double out = this.activeFunction.function(sigma);
                if (rnnMatrix != null) {
                    out += rnnMatrix.getNumber(this.depth, this.getId() - 1);
                }
                if (isKernelStudy) {
                    this.outNub = out;
                } else {
                    this.destoryParameter(eventId);
                }
                if (rnnMatrix != null && rnnMatrix.getX() == this.depth + 1) {
                    this.sendRnnMessage(eventId, out, isKernelStudy, E, outBack, false, rnnMatrix);
                } else {
                    this.sendMessage(eventId, out, isKernelStudy, E, outBack, false, rnnMatrix);
                }
            }
        }
    }

    @Override
    protected void inputMatrix(long eventId, Matrix matrix, boolean isStudy, int E, OutBack outBack) throws Exception {
        Matrix myMatrix = this.conv(matrix);
        this.sendMatrix(eventId, myMatrix, isStudy, E, outBack);
    }
}

