/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.tools;

public class IdCreator {
    public static final long sequenceBits = 12L;
    public static final long workBits = 4L;
    public static long workId = 1L;
    public static final long workAndBusBites = 16L;
    private static final long sequenceMask = 4095L;
    private static IdCreator AcceptorId = new IdCreator();
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;

    private IdCreator() {
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = this.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp << 16 | sequence << 4 | workId;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static IdCreator get() {
        return AcceptorId;
    }
}

