/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;
import org.wlld.tools.MatrixBody;

public class LVQ {
    private int typeNub;
    private MatrixBody[] model;
    private final List<MatrixBody> matrixList = new ArrayList<MatrixBody>();
    private final double studyPoint;
    private int length;
    private boolean isReady = false;
    private final int lvqNub;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public void setTypeNub(int typeNub) {
        this.typeNub = typeNub;
    }

    public void setModel(MatrixBody[] model) {
        this.model = model;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public int getTypeNub() {
        return this.typeNub;
    }

    public int getLength() {
        return this.length;
    }

    public LVQ(int typeNub, int lvqNub, double studyPoint) {
        this.typeNub = typeNub;
        this.lvqNub = lvqNub;
        this.studyPoint = studyPoint;
        this.model = new MatrixBody[typeNub];
    }

    public MatrixBody[] getModel() throws Exception {
        if (!this.isReady) {
            throw new Exception("not study");
        }
        return this.model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertMatrixBody(MatrixBody matrixBody) throws Exception {
        if (!matrixBody.getMatrix().isVector() || !matrixBody.getMatrix().isRowVector()) throw new Exception("this matrix is not vector or rowVector");
        Matrix matrix = matrixBody.getMatrix();
        if (this.matrixList.size() == 0) {
            this.matrixList.add(matrixBody);
            this.length = matrix.getY();
            return;
        } else {
            if (this.length != matrix.getY()) throw new Exception("vector length is different");
            this.matrixList.add(matrixBody);
        }
    }

    private void study() throws Exception {
        for (MatrixBody matrixBody : this.matrixList) {
            Matrix matrix = matrixBody.getMatrix();
            long type = matrixBody.getId();
            double distEnd = 0.0;
            int id = 0;
            for (int i = 0; i < this.typeNub; ++i) {
                MatrixBody modelBody = this.model[i];
                Matrix modelMatrix = modelBody.getMatrix();
                double dist = this.vectorEqual(modelMatrix, matrix);
                if (distEnd != 0.0 && !(dist < distEnd)) continue;
                id = modelBody.getId();
                distEnd = dist;
            }
            MatrixBody modelBody = this.model[id];
            Matrix modelMatrix = modelBody.getMatrix();
            boolean isRight = (long)id == type;
            Matrix matrix1 = this.op(matrix, modelMatrix, isRight);
            modelBody.setMatrix(matrix1);
        }
    }

    public double vectorEqual(Matrix matrix1, Matrix matrix2) throws Exception {
        Matrix matrix = this.matrixOperation.sub(matrix1, matrix2);
        return this.matrixOperation.getNorm(matrix);
    }

    private Matrix op(Matrix matrix, Matrix modelMatrix, boolean isRight) throws Exception {
        Matrix matrix1 = this.matrixOperation.sub(matrix, modelMatrix);
        this.matrixOperation.mathMul(matrix1, this.studyPoint);
        Matrix matrix2 = isRight ? this.matrixOperation.add(modelMatrix, matrix1) : this.matrixOperation.sub(modelMatrix, matrix1);
        return matrix2;
    }

    public void start() throws Exception {
        int i;
        Random random = new Random();
        for (i = 0; i < this.typeNub; ++i) {
            MatrixBody matrixBody = new MatrixBody();
            Matrix matrix = new Matrix(1, this.length);
            matrixBody.setMatrix(matrix);
            matrixBody.setId(i);
            for (int j = 0; j < this.length; ++j) {
                matrix.setNub(0, j, random.nextDouble());
            }
            this.model[i] = matrixBody;
        }
        for (i = 0; i < this.lvqNub; ++i) {
            this.study();
        }
        this.isReady = true;
    }
}

