/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.wlld.entity.RGBNorm;
import org.wlld.tools.MeanSort;

public class MeanClustering {
    protected List<double[]> matrixList = new ArrayList<double[]>();
    private int length;
    protected int speciesQuantity;
    private final int maxTimes;
    protected List<RGBNorm> matrices = new ArrayList<RGBNorm>();

    public List<RGBNorm> getMatrices() {
        return this.matrices;
    }

    public double[] getResultByNorm() {
        MeanSort meanSort = new MeanSort();
        double[] dm = new double[this.matrices.size() * this.length];
        this.matrices.sort(meanSort);
        for (int i = 0; i < this.matrices.size(); ++i) {
            RGBNorm rgbNorm = this.matrices.get(i);
            double[] rgb = rgbNorm.getRgb();
            for (int j = 0; j < rgb.length; ++j) {
                dm[i * rgb.length + j] = rgb[j];
            }
        }
        return dm;
    }

    public MeanClustering(int speciesQuantity, int maxTimes) throws Exception {
        this.speciesQuantity = speciesQuantity;
        this.maxTimes = maxTimes;
    }

    public void setFeature(double[] feature) throws Exception {
        if (this.matrixList.isEmpty()) {
            this.matrixList.add(feature);
            this.length = feature.length;
        } else if (this.length == feature.length) {
            this.matrixList.add(feature);
        } else {
            throw new Exception("vector length is different");
        }
    }

    private void averageMatrix() {
        for (double[] rgb : this.matrixList) {
            double min = -1.0;
            int id = 0;
            for (int i = 0; i < this.speciesQuantity; ++i) {
                RGBNorm rgbNorm = this.matrices.get(i);
                double dist = rgbNorm.getEDist(rgb);
                if (min != -1.0 && !(dist < min)) continue;
                min = dist;
                id = i;
            }
            RGBNorm rgbNorm = this.matrices.get(id);
            rgbNorm.setColor(rgb);
        }
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.norm();
        }
    }

    private boolean isNext() {
        RGBNorm rgbNorm;
        boolean isNext = false;
        Iterator<RGBNorm> iterator = this.matrices.iterator();
        while (iterator.hasNext() && !(isNext = (rgbNorm = iterator.next()).compare())) {
        }
        return isNext;
    }

    private void clear() {
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.clear();
        }
    }

    public void start() throws Exception {
        if (this.matrixList.size() > 1) {
            Random random = new Random();
            for (int i = 0; i < this.speciesQuantity; ++i) {
                int index = random.nextInt(this.matrixList.size());
                double[] rgb = this.matrixList.get(index);
                RGBNorm rgbNorm = new RGBNorm(rgb, this.length);
                this.matrices.add(rgbNorm);
            }
            for (int i = 0; i < this.maxTimes; ++i) {
                this.averageMatrix();
                boolean isNext = this.isNext();
                if (isNext && i < this.maxTimes - 1) {
                    this.clear();
                    continue;
                }
                break;
            }
        } else {
            throw new Exception("matrixList number less than 2");
        }
    }
}

