/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.transFormer.seflAttention;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;
import org.wlld.transFormer.CodecBlock;
import org.wlld.transFormer.model.MultiSelfAttentionModel;
import org.wlld.transFormer.model.QKVModel;
import org.wlld.transFormer.seflAttention.AttentionError;
import org.wlld.transFormer.seflAttention.EventBody;
import org.wlld.transFormer.seflAttention.LayNorm;
import org.wlld.transFormer.seflAttention.SelfAttention;

public class MultiSelfAttention {
    private final CodecBlock codecBlock;
    private final List<SelfAttention> selfAttentions = new ArrayList<SelfAttention>();
    private LayNorm layNorm;
    private final double studyPoint;
    private Matrix powerMatrix;
    private final int multiNumber;
    private final int wordVectorDimension;
    private Matrix featureMatrix;
    private final int depth;
    private final boolean encoder;
    private final int maxLength;
    private final boolean selfTimeCode;
    private final MatrixOperation matrixOperation;

    public void setLayNorm(LayNorm layNorm) {
        this.layNorm = layNorm;
    }

    public int getDepth() {
        return this.depth;
    }

    private QKVModel getQKV(List<QKVModel> qkvModelList, int selfID) {
        QKVModel myQKV = null;
        for (QKVModel qkvModel : qkvModelList) {
            if (qkvModel.getSelfID() != selfID) continue;
            myQKV = qkvModel;
            break;
        }
        return myQKV;
    }

    public void insertModel(MultiSelfAttentionModel multiSelfAttentionModel) throws Exception {
        this.insertPower(multiSelfAttentionModel.getPowerModel(), this.powerMatrix);
        List<QKVModel> qkvModelList = multiSelfAttentionModel.getQkvModelList();
        for (int i = 0; i < this.selfAttentions.size(); ++i) {
            QKVModel qkvModel = this.getQKV(qkvModelList, i);
            if (qkvModel == null) {
                throw new Exception("\u6a21\u578b\u4e0e\u6fc0\u6d3b\u53c2\u6570\u4e0d\u5339\u914d!\u5185\u5b58\u4e0e\u6a21\u578b\u6587\u4ef6\u7684\u591a\u5934\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            }
            this.selfAttentions.get(i).insertModel(qkvModel);
        }
    }

    private void insertPower(double[][] modelPower, Matrix power) throws Exception {
        for (int i = 0; i < power.getX(); ++i) {
            for (int j = 0; j < power.getY(); ++j) {
                power.setNub(i, j, modelPower[i][j]);
            }
        }
    }

    public MultiSelfAttentionModel getModel() {
        MultiSelfAttentionModel multiSelfAttentionModel = new MultiSelfAttentionModel();
        ArrayList<QKVModel> qkvModelList = new ArrayList<QKVModel>();
        for (SelfAttention selfAttention : this.selfAttentions) {
            qkvModelList.add(selfAttention.getModel());
        }
        multiSelfAttentionModel.setPowerModel(this.powerMatrix.getMatrix());
        multiSelfAttentionModel.setQkvModelList(qkvModelList);
        multiSelfAttentionModel.setDepth(this.depth);
        return multiSelfAttentionModel;
    }

    private void mergeFeatureMatrix(Matrix myMultiFeature, Matrix matrix, int index) throws Exception {
        int startY = this.wordVectorDimension * index;
        int endY = startY + this.wordVectorDimension;
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = startY; j < endY; ++j) {
                myMultiFeature.setNub(i, j, matrix.getNumber(i, j - startY));
            }
        }
    }

    private List<Matrix> splitMatrix(Matrix subFeature) {
        ArrayList<Matrix> matrixList = new ArrayList<Matrix>();
        int maxDeep = subFeature.getX();
        for (int i = 0; i < this.selfAttentions.size(); ++i) {
            Matrix matrix = subFeature.getSonOfMatrix(0, i * this.wordVectorDimension, maxDeep, this.wordVectorDimension);
            matrixList.add(matrix);
        }
        return matrixList;
    }

    public void backError(Matrix allErrorMatrix, long eventID) throws Exception {
        Matrix error = this.matrixOperation.mathMulBySelf(allErrorMatrix, this.studyPoint);
        Matrix subPower = this.matrixOperation.matrixMulPd(error, this.featureMatrix, this.powerMatrix, false);
        Matrix subFeature = this.matrixOperation.matrixMulPd(allErrorMatrix, this.featureMatrix, this.powerMatrix, true);
        this.powerMatrix = this.matrixOperation.add(this.powerMatrix, subPower);
        List<Matrix> matrixList = this.splitMatrix(subFeature);
        Matrix allNextFeatureError = null;
        Matrix allLastEncoderError = null;
        for (int i = 0; i < this.selfAttentions.size(); ++i) {
            AttentionError attentionError = this.getSefAttentionBySelfID(i).backError(matrixList.get(i), eventID);
            Matrix nextFeatureError = attentionError.getNextFeatureError();
            allNextFeatureError = allNextFeatureError == null ? nextFeatureError : this.matrixOperation.add(allNextFeatureError, nextFeatureError);
            if (this.encoder || this.depth <= 1) continue;
            Matrix lastEncoderError = attentionError.getLastEncoderError();
            allLastEncoderError = allLastEncoderError == null ? lastEncoderError : this.matrixOperation.add(allLastEncoderError, lastEncoderError);
        }
        if (!this.encoder && this.depth > 1) {
            this.codecBlock.backLastEncoderError(allLastEncoderError);
        }
        if (this.codecBlock != null) {
            this.codecBlock.backCodecError(allNextFeatureError, eventID, allErrorMatrix);
        }
    }

    private SelfAttention getSefAttentionBySelfID(int selfID) {
        SelfAttention mySelfAttention = null;
        for (SelfAttention selfAttention : this.selfAttentions) {
            if (selfAttention.getSelfID() != selfID) continue;
            mySelfAttention = selfAttention;
            break;
        }
        return mySelfAttention;
    }

    private Matrix countMultiSelfAttention(List<EventBody> eventBodies, boolean isStudy) throws Exception {
        int one = this.wordVectorDimension * this.multiNumber;
        Matrix myMultiFeature = null;
        for (int i = 0; i < eventBodies.size(); ++i) {
            EventBody eventBody = this.getEventBodyBySelfID(i, eventBodies);
            Matrix matrix = eventBody.getFeatureMatrix();
            if (i == 0) {
                myMultiFeature = new Matrix(matrix.getX(), one);
            }
            this.mergeFeatureMatrix(myMultiFeature, matrix, i);
        }
        Matrix out = this.matrixOperation.mulMatrix(myMultiFeature, this.powerMatrix);
        if (isStudy) {
            this.featureMatrix = myMultiFeature;
        }
        return out;
    }

    private EventBody getEventBodyBySelfID(int selfID, List<EventBody> eventBodies) {
        EventBody eventBody = null;
        for (EventBody myEventBody : eventBodies) {
            if (myEventBody.getSelfID() != selfID) continue;
            eventBody = myEventBody;
            break;
        }
        return eventBody;
    }

    private void addTimeCode(Matrix feature) throws Exception {
        int x = feature.getX();
        int y = feature.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                int k = j / 2;
                double wk = 1.0 / Math.pow(10000.0, 2.0 * (double)k / (double)y);
                double pe = j % 2 == 0 ? Math.sin(wk * (double)i) : Math.cos(wk * (double)i);
                double value = feature.getNumber(i, j) + pe;
                feature.setNub(i, j, value);
            }
        }
    }

    private void addTimeCodeBySelf(Matrix feature) throws Exception {
        double timeStep = 1.0 / (double)this.maxLength;
        int x = feature.getX();
        int y = feature.getY();
        for (int i = 1; i < x; ++i) {
            double step = (double)i * timeStep;
            for (int j = 0; j < y; ++j) {
                double value = feature.getNumber(i, j) + step;
                feature.setNub(i, j, value);
            }
        }
    }

    public void sendMatrixMessage(long eventID, Matrix feature, boolean isStudy, OutBack outBack, List<Integer> E, Matrix encoderFeature, boolean outAllPro) throws Exception {
        if (this.depth == 1) {
            if (this.selfTimeCode) {
                this.addTimeCodeBySelf(feature);
            } else {
                this.addTimeCode(feature);
            }
        }
        ArrayList<EventBody> eventBodies = new ArrayList<EventBody>();
        for (SelfAttention selfAttention : this.selfAttentions) {
            EventBody eventBody = selfAttention.sendMatrixFeature(eventID, isStudy, feature, encoderFeature);
            eventBodies.add(eventBody);
        }
        Matrix matrix = this.countMultiSelfAttention(eventBodies, isStudy);
        this.layNorm.addNorm(feature, matrix, eventID, isStudy, outBack, E, encoderFeature, outAllPro);
    }

    public MultiSelfAttention(int multiNumber, double studyPoint, int depth, int wordVectorDimension, boolean encoder, CodecBlock codecBlock, int maxLength, boolean selfTimeCode, int coreNumber) throws Exception {
        Random random = new Random();
        this.matrixOperation = new MatrixOperation(coreNumber);
        this.selfTimeCode = selfTimeCode;
        this.maxLength = maxLength;
        this.codecBlock = codecBlock;
        this.encoder = encoder;
        int yiZhi = wordVectorDimension * multiNumber;
        this.studyPoint = studyPoint;
        this.wordVectorDimension = wordVectorDimension;
        this.multiNumber = multiNumber;
        this.depth = depth;
        for (int k = 0; k < multiNumber; ++k) {
            SelfAttention selfAttention = new SelfAttention(studyPoint, depth, wordVectorDimension, k, encoder, coreNumber);
            this.selfAttentions.add(selfAttention);
        }
        this.powerMatrix = new Matrix(yiZhi, wordVectorDimension);
        int x = this.powerMatrix.getX();
        int y = this.powerMatrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                this.powerMatrix.setNub(i, j, random.nextDouble() / (double)yiZhi);
            }
        }
    }
}

