/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage.languageCreator;

import java.util.ArrayList;
import java.util.List;
import org.wlld.gameRobot.Action;

public class WordLeft
extends Action {
    private List<String> keyWords;
    private List<String> finishWords;

    public WordLeft(List<String> keyWords, List<String> finishWords) {
        this.keyWords = keyWords;
        this.finishWords = finishWords;
    }

    private boolean isFinish(String myWord) {
        boolean isHere = false;
        for (String finishWord : this.finishWords) {
            if (finishWord.hashCode() != myWord.hashCode() || !finishWord.equals(myWord)) continue;
            isHere = true;
            break;
        }
        return isHere;
    }

    @Override
    public int getActionId() {
        return super.getActionId();
    }

    @Override
    public void setActionId(int actionId) {
        super.setActionId(actionId);
    }

    @Override
    public List<int[]> action(int[] stateId) {
        int id = stateId[0];
        String myWord = this.keyWords.get(id - 1);
        int len = myWord.length() + 1;
        int size = this.keyWords.size();
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i = 0; i < size; ++i) {
            String word = this.keyWords.get(i);
            if (word.length() != len || !word.substring(1).equals(myWord)) continue;
            list.add(new int[]{i + 1});
        }
        return list;
    }

    @Override
    protected int getProfit(int[] stateId) {
        int allProfit = 0;
        List<int[]> states = this.action(stateId);
        if (states.isEmpty()) {
            allProfit = -10;
        } else {
            for (int i = 0; i < states.size(); ++i) {
                int nextID = states.get(i)[0];
                if (nextID > 0) {
                    String myWord = this.keyWords.get(nextID - 1);
                    if (!this.isFinish(myWord)) continue;
                    allProfit += 10;
                    continue;
                }
                allProfit -= 10;
            }
            allProfit /= states.size();
        }
        return allProfit;
    }
}

