/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.rnnJumpNerveEntity;

import java.util.HashMap;
import java.util.Map;
import org.wlld.i.ActiveFunction;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.rnnJumpNerveEntity.Nerve;

public class HiddenNerve
extends Nerve {
    private final Map<Long, Double> outMap = new HashMap<Long, Double>();

    public HiddenNerve(int id, int depth, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, double lParam, int step, int kernLen, int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int allDepth, boolean creator, int startDepth) throws Exception {
        super(id, "HiddenNerve", studyPoint, init, activeFunction, isDynamic, rzType, lParam, step, kernLen, sensoryNerveNub, hiddenNerveNub, outNerveNub, allDepth, creator, startDepth);
        this.depth = depth;
    }

    @Override
    public void input(long eventId, double parameter, boolean isKernelStudy, Map<Integer, Double> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            double sigma = this.calculation(eventId);
            double out = this.activeFunction.function(sigma);
            if (isKernelStudy) {
                this.outNub = out;
            }
            if (rnnMatrix != null) {
                out = !this.creator || this.depth < this.startDepth ? (out += rnnMatrix.getNumber(this.depth, this.getId() - 1)) : (out += rnnMatrix.getNumber(this.depth - this.startDepth + questionLength, this.getId() - 1));
            }
            if (!isKernelStudy) {
                this.destroyParameter(eventId);
            }
            this.sendMessage(eventId, out, isKernelStudy, E, outBack, rnnMatrix, storeys, index, questionLength);
        }
    }

    @Override
    protected void sendAppointTestMessage(long eventId, double parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            double sigma = this.calculation(eventId);
            double out = this.activeFunction.function(sigma);
            this.destroyParameter(eventId);
            this.outMap.put(eventId, out += featureMatrix.getNumber(featureMatrix.getX() - 1, this.getId() - 1));
            this.sendRnnTestMessage(eventId, out, featureMatrix, outBack, myWord);
        }
    }

    @Override
    protected void sendMyTestMessage(long eventId, Matrix featureMatrix, OutBack outBack, String word) throws Exception {
        double out = this.outMap.get(eventId);
        this.outMap.remove(eventId);
        this.sendTestMessage(eventId, out, featureMatrix, outBack, word);
    }

    @Override
    protected void clearData(long eventId) {
        this.outMap.remove(eventId);
    }

    @Override
    protected void inputMatrix(long eventId, Matrix matrix, boolean isStudy, int E, OutBack outBack) throws Exception {
        Matrix myMatrix = this.conv(matrix);
        this.sendMatrix(eventId, myMatrix, isStudy, E, outBack);
    }
}

