/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.rnnJumpNerveEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.wlld.i.ActiveFunction;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.matrixTools.MatrixOperation;

public abstract class Nerve {
    private final Map<Integer, List<Nerve>> son = new HashMap<Integer, List<Nerve>>();
    private final Map<Integer, List<Nerve>> father = new HashMap<Integer, List<Nerve>>();
    private final List<Nerve> rnnOut = new ArrayList<Nerve>();
    protected Map<Integer, Double> dendrites = new HashMap<Integer, Double>();
    protected Map<Integer, Double> wg = new HashMap<Integer, Double>();
    private final int id;
    boolean fromOutNerve = false;
    private final int hiddenNerveNub;
    private final int sensoryNerveNub;
    private final int outNerveNub;
    protected Map<Long, List<Double>> features = new HashMap<Long, List<Double>>();
    protected Matrix nerveMatrix;
    protected double threshold;
    protected String name;
    protected double outNub;
    protected double E;
    protected double gradient;
    protected double studyPoint;
    protected double sigmaW;
    private int backNub = 0;
    protected ActiveFunction activeFunction;
    private final int rzType;
    private final double lParam;
    private final int step;
    private final int kernLen;
    private Matrix im2col;
    private int xInput;
    private int yInput;
    private Matrix outMatrix;
    private int myUpNumber;
    protected int depth;
    protected int allDepth;
    protected boolean creator;
    protected int startDepth;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public int getDepth() {
        return this.depth;
    }

    public Map<Integer, Double> getDendrites() {
        return this.dendrites;
    }

    public Matrix getNerveMatrix() {
        return this.nerveMatrix;
    }

    public void setNerveMatrix(Matrix nerveMatrix) {
        this.nerveMatrix = nerveMatrix;
    }

    public void setDendrites(Map<Integer, Double> dendrites) {
        this.dendrites = dendrites;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    protected Nerve(int id, String name, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, double lParam, int step, int kernLen, int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int allDepth, boolean creator, int startDepth) throws Exception {
        this.id = id;
        this.creator = creator;
        this.startDepth = startDepth;
        this.allDepth = allDepth;
        this.hiddenNerveNub = hiddenNerveNub;
        this.sensoryNerveNub = sensoryNerveNub;
        this.outNerveNub = outNerveNub;
        this.name = name;
        this.studyPoint = studyPoint;
        this.activeFunction = activeFunction;
        this.rzType = rzType;
        this.lParam = lParam;
        this.step = step;
        this.kernLen = kernLen;
        if (name.equals("OutNerve")) {
            this.fromOutNerve = true;
        }
        this.initPower(init, isDynamic);
    }

    protected void setStudyPoint(double studyPoint) {
        this.studyPoint = studyPoint;
    }

    private int getNextStorey(int[] storeys, int index) {
        int nextStorey = -1;
        int nextIndex = index + 1;
        if (storeys.length > nextIndex) {
            nextStorey = storeys[nextIndex];
        }
        return nextStorey;
    }

    protected void sendSoftMaxBack(long eventId, double parameter, Matrix rnnMatrix, OutBack outBack, String myWord) throws Exception {
        if (!this.son.isEmpty()) {
            List<Nerve> nerverList = this.son.get(0);
            for (Nerve nerve : nerverList) {
                nerve.sendAppointSoftMax(eventId, parameter, rnnMatrix, outBack, myWord);
            }
        } else {
            throw new Exception("this storey is lastIndex");
        }
    }

    protected void sendSoftMax(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index) throws Exception {
        if (!this.son.isEmpty()) {
            List<Nerve> nerverList = this.son.get(0);
            for (Nerve nerve : nerverList) {
                nerve.input(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index, 0);
            }
        } else {
            throw new Exception("this storey is lastIndex");
        }
    }

    protected void clearData(long eventId) {
    }

    protected void sendMyTestMessage(long eventId, Matrix featureMatrix, OutBack outBack, String word) throws Exception {
    }

    protected void sendAppointSoftMax(long eventId, double parameter, Matrix rnnMatrix, OutBack outBack, String myWord) throws Exception {
    }

    protected void sendAppointTestMessage(long eventId, double parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendTestMessage(long eventId, double parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        if (this.son.isEmpty()) throw new Exception("this layer is lastIndex");
        List<Nerve> nerveList = this.son.get(this.depth + 1);
        if (nerveList == null) throw new Exception("Insufficient layer:" + this.depth + 1);
        for (Nerve nerve : nerveList) {
            nerve.sendAppointTestMessage(eventId, parameter, featureMatrix, outBack, myWord);
        }
    }

    protected void sendRnnTestMessage(long eventId, double parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        if (!this.rnnOut.isEmpty()) {
            for (Nerve nerve : this.rnnOut) {
                nerve.sendAppointTestMessage(eventId, parameter, featureMatrix, outBack, myWord);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    protected void sendMessage(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
        List<Nerve> nerveList = null;
        int nextStorey = 0;
        if (storeys == null) {
            nerveList = this.son.get(0);
        } else {
            nextStorey = this.getNextStorey(storeys, index);
            if (nextStorey > -1) {
                nerveList = this.son.get(nextStorey);
                ++index;
                if (nerveList == null) {
                    throw new Exception("\u5411\u524d->\u8981\u67e5\u627e\u7684\u5c42\u6570\u4e0d\u5b58\u5728\u94fe\u63a5\uff0c\u5e8f\u5217\uff1a" + index + "\u5c42\u6570:" + nextStorey + ",\u5f53\u524d\u6240\u5728\u5c42\u6570:" + this.depth + ",\u6211\u7684\u8eab\u4efd:" + this.name);
                }
            }
        }
        if (nerveList != null) {
            if (this.creator && !isStudy && nextStorey == this.startDepth) {
                for (Nerve nerve : nerveList) {
                    nerve.sendAppointTestMessage(eventId, parameter, rnnMatrix, outBack, null);
                }
            } else {
                for (Nerve nerve : nerveList) {
                    nerve.input(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index, questionLength);
                }
            }
        } else {
            this.sendRnnMessage(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index);
        }
    }

    private void sendRnnMessage(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index) throws Exception {
        if (!this.rnnOut.isEmpty()) {
            for (Nerve nerve : this.rnnOut) {
                nerve.input(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index, 0);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    protected Matrix conv(Matrix matrix) throws Exception {
        this.xInput = matrix.getX();
        this.yInput = matrix.getY();
        int sub = this.kernLen - this.step;
        int x = (this.xInput - sub) / this.step;
        int y = (this.yInput - sub) / this.step;
        Matrix myMatrix = new Matrix(x, y);
        this.im2col = this.matrixOperation.im2col(matrix, this.kernLen, this.step);
        Matrix matrixOut = this.matrixOperation.mulMatrix(this.im2col, this.nerveMatrix);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                double nub = this.activeFunction.function(matrixOut.getNumber(i * y + j, 0));
                myMatrix.setNub(i, j, nub);
            }
        }
        this.outMatrix = myMatrix;
        return myMatrix;
    }

    protected void sendMatrix(long eventId, Matrix parameter, boolean isStudy, int E, OutBack outBack) throws Exception {
        if (!this.son.isEmpty()) {
            for (Nerve nerve : this.son.get(0)) {
                nerve.inputMatrix(eventId, parameter, isStudy, E, outBack);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    private void backSendMessage(long eventId, boolean fromOutNerve, int[] storeys, int index) throws Exception {
        if (!this.father.isEmpty()) {
            List<Nerve> nerveList = null;
            if (storeys == null) {
                nerveList = this.father.get(0);
            } else if (index > 0) {
                nerveList = this.father.get(storeys[index]);
                if (nerveList == null) {
                    throw new Exception("\u5411\u540e->\u8981\u67e5\u627e\u7684\u5c42\u6570\u4e0d\u5b58\u5728\u94fe\u63a5\uff0c\u5e8f\u5217\uff1a" + index + "\u76ee\u6807\u5c42\u6570:" + storeys[index] + ",\u5f53\u524d\u6240\u5728\u5c42\u6570:" + this.depth + ",\u6211\u7684\u8eab\u4efd:" + this.name);
                }
                --index;
            }
            if (nerveList != null) {
                for (int i = 0; i < nerveList.size(); ++i) {
                    nerveList.get(i).backGetMessage(this.wg.get(i + 1), eventId, fromOutNerve, storeys, index);
                }
            }
        }
    }

    private void backMatrixMessage(Matrix g) throws Exception {
        if (!this.father.isEmpty()) {
            for (Nerve nerve : this.father.get(0)) {
                nerve.backMatrix(g);
            }
        }
    }

    protected void input(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack imageBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
    }

    protected void inputMatrix(long eventId, Matrix matrix, boolean isKernelStudy, int E, OutBack outBack) throws Exception {
    }

    private void backGetMessage(double parameter, long eventId, boolean fromOutNerve, int[] storeys, int index) throws Exception {
        ++this.backNub;
        this.sigmaW += parameter;
        int number = fromOutNerve ? this.outNerveNub : this.hiddenNerveNub;
        if (this.backNub == number) {
            this.backNub = 0;
            this.gradient = this.activeFunction.functionG(this.outNub) * this.sigmaW;
            this.updatePower(eventId, storeys, index);
        }
    }

    protected void backMatrix(Matrix g) throws Exception {
        int x = g.getX();
        int y = g.getY();
        Matrix yc = new Matrix(x * y, 1);
        int index = 0;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                double error = g.getNumber(i, j);
                double out = this.outMatrix.getNumber(i, j);
                error = error * this.activeFunction.functionG(out) * this.studyPoint;
                yc.setNub(index, 0, error);
                ++index;
            }
        }
        Matrix trx = this.matrixOperation.transPosition(this.im2col);
        Matrix wSub = this.matrixOperation.mulMatrix(trx, yc);
        x = this.im2col.getX();
        y = this.im2col.getY() - 1;
        for (int i = 0; i < x; ++i) {
            double ySub = yc.getNumber(i, 0);
            for (int j = 0; j < y; ++j) {
                double k = this.nerveMatrix.getNumber(j, 0) * ySub;
                this.im2col.setNub(i, j, k);
            }
        }
        Matrix gNext = this.matrixOperation.reverseIm2col(this.im2col, this.kernLen, this.step, this.xInput, this.yInput);
        this.nerveMatrix = this.matrixOperation.add(this.nerveMatrix, wSub);
        this.backMatrixMessage(gNext);
    }

    protected void updatePower(long eventId, int[] storeys, int index) throws Exception {
        double h = this.gradient * this.studyPoint;
        this.threshold -= h;
        this.updateW(h, eventId);
        this.sigmaW = 0.0;
        this.backSendMessage(eventId, this.fromOutNerve, storeys, index);
    }

    private double regularization(double w, double param) {
        double re = 0.0;
        if (this.rzType != 0) {
            if (this.rzType == 2) {
                re = param * -w;
            } else if (this.rzType == 1) {
                if (w > 0.0) {
                    re = -param;
                } else if (w < 0.0) {
                    re = param;
                }
            }
        }
        return re;
    }

    private void updateW(double h, long eventId) {
        List<Double> list = this.features.get(eventId);
        double param = 0.0;
        if (this.rzType != 0) {
            double sigma = 0.0;
            for (Map.Entry<Integer, Double> entry : this.dendrites.entrySet()) {
                if (this.rzType == 2) {
                    sigma += Math.pow(entry.getValue(), 2.0);
                    continue;
                }
                sigma += Math.abs(entry.getValue());
            }
            param = sigma * this.lParam * this.studyPoint;
        }
        for (Map.Entry<Integer, Double> entry : this.dendrites.entrySet()) {
            int key = entry.getKey();
            double w = entry.getValue();
            double bn = list.get(key - 1);
            double wp = bn * h;
            double dm = w * this.gradient;
            double regular = this.regularization(w, param);
            w += regular;
            this.wg.put(key, dm);
            this.dendrites.put(key, w += wp);
        }
        this.features.remove(eventId);
    }

    protected boolean insertParameter(long eventId, double parameter) throws Exception {
        List<Object> featuresList;
        boolean allReady = false;
        if (this.features.containsKey(eventId)) {
            featuresList = this.features.get(eventId);
        } else {
            featuresList = new ArrayList();
            this.features.put(eventId, featuresList);
        }
        featuresList.add(parameter);
        if (featuresList.size() == this.myUpNumber) {
            allReady = true;
        } else if (featuresList.size() > this.myUpNumber) {
            throw new Exception("\u63a5\u6536\u53c2\u6570\u6570\u91cf\u5f02\u5e38");
        }
        return allReady;
    }

    protected void destroyParameter(long eventId) {
        this.features.remove(eventId);
    }

    protected double calculation(long eventId) {
        double sigma = 0.0;
        List<Double> featuresList = this.features.get(eventId);
        for (int i = 0; i < featuresList.size(); ++i) {
            double value = featuresList.get(i);
            double w = this.dendrites.get(i + 1);
            sigma = w * value + sigma;
        }
        return sigma - this.threshold;
    }

    private void initPower(boolean init, boolean isDynamic) throws Exception {
        Random random = new Random();
        if (!isDynamic) {
            this.myUpNumber = this.name.equals("HiddenNerve") ? this.sensoryNerveNub : (this.name.equals("OutNerve") ? this.hiddenNerveNub : this.outNerveNub);
            if (this.myUpNumber > 0) {
                double sh = Math.sqrt(this.myUpNumber);
                for (int i = 1; i < this.myUpNumber + 1; ++i) {
                    double nub = 0.0;
                    if (init) {
                        nub = random.nextDouble() / sh;
                    }
                    this.dendrites.put(i, nub);
                }
                double nub = 0.0;
                if (init) {
                    nub = random.nextDouble() / sh;
                }
                this.threshold = nub;
            }
        } else {
            int nerveNub = this.kernLen * this.kernLen;
            double sh = Math.sqrt(2.0 / (double)nerveNub);
            this.nerveMatrix = new Matrix(nerveNub + 1, 1);
            for (int i = 0; i < this.nerveMatrix.getX(); ++i) {
                double nub = 0.0;
                if (init) {
                    nub = random.nextDouble() * sh;
                }
                this.nerveMatrix.setNub(i, 0, nub);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void connect(int depth, List<Nerve> nerveList) {
        this.son.put(depth, nerveList);
    }

    public void connectOut(List<Nerve> nerveList) {
        this.rnnOut.addAll(nerveList);
    }

    public void connectFather(int depth, List<Nerve> nerveList) {
        this.father.put(depth, nerveList);
    }
}

