/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.transFormer;

import java.util.ArrayList;
import java.util.List;
import org.wlld.config.TfConfig;
import org.wlld.matrixTools.Matrix;
import org.wlld.transFormer.CodecBlock;
import org.wlld.transFormer.FirstDecoderBlock;
import org.wlld.transFormer.LineBlock;
import org.wlld.transFormer.model.CodecBlockModel;
import org.wlld.transFormer.model.TransFormerModel;
import org.wlld.transFormer.nerve.SensoryNerve;

public class TransFormerManager {
    private final SensoryNerve sensoryNerve;
    private final List<CodecBlock> encoderBlocks = new ArrayList<CodecBlock>();
    private final List<CodecBlock> decoderBlocks = new ArrayList<CodecBlock>();
    private final FirstDecoderBlock firstDecoderBlock;
    private final LineBlock lineBlock;
    private final int maxLength;
    private final boolean selfTimeCode;

    public SensoryNerve getSensoryNerve() {
        return this.sensoryNerve;
    }

    public TransFormerModel getModel() {
        TransFormerModel transFormerModel = new TransFormerModel();
        ArrayList<CodecBlockModel> encoderBlockModels = new ArrayList<CodecBlockModel>();
        ArrayList<CodecBlockModel> decoderBlockModels = new ArrayList<CodecBlockModel>();
        for (int i = 0; i < this.encoderBlocks.size(); ++i) {
            encoderBlockModels.add(this.encoderBlocks.get(i).getModel());
            decoderBlockModels.add(this.decoderBlocks.get(i).getModel());
        }
        transFormerModel.setEncoderBlockModels(encoderBlockModels);
        transFormerModel.setDecoderBlockModels(decoderBlockModels);
        transFormerModel.setFirstDecoderBlockModel(this.firstDecoderBlock.getModel());
        transFormerModel.setLineBlockModel(this.lineBlock.getModel());
        return transFormerModel;
    }

    private Matrix addTimeCode(Matrix feature) throws Exception {
        int x = feature.getX();
        int y = feature.getY();
        Matrix matrix = new Matrix(x, y);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                int k = j / 2;
                double wk = 1.0 / Math.pow(10000.0, 2.0 * (double)k / (double)y);
                double pe = j % 2 == 0 ? Math.sin(wk * (double)i) : Math.cos(wk * (double)i);
                double value = feature.getNumber(i, j) + pe;
                matrix.setNub(i, j, value);
            }
        }
        return matrix;
    }

    private Matrix addTimeCodeBySelf(Matrix feature) throws Exception {
        double timeStep = 1.0 / (double)this.maxLength;
        int x = feature.getX();
        int y = feature.getY();
        Matrix matrix = new Matrix(x, y);
        for (int i = 1; i < x; ++i) {
            double step = (double)i * timeStep;
            for (int j = 0; j < y; ++j) {
                double value = feature.getNumber(i, j) + step;
                matrix.setNub(i, j, value);
            }
        }
        return matrix;
    }

    public Matrix getStartMatrix(Matrix feature) throws Exception {
        Matrix matrix = this.selfTimeCode ? this.addTimeCodeBySelf(feature) : this.addTimeCode(feature);
        Matrix myFeature = new Matrix(1, matrix.getY());
        for (int j = 0; j < matrix.getY(); ++j) {
            Matrix col = matrix.getColumn(j);
            double value = col.getAVG();
            myFeature.setNub(0, j, value);
        }
        return myFeature;
    }

    public void insertModel(TransFormerModel transFormerModel) throws Exception {
        List<CodecBlockModel> encoderBlockModels = transFormerModel.getEncoderBlockModels();
        List<CodecBlockModel> decoderBlockModels = transFormerModel.getDecoderBlockModels();
        for (int i = 0; i < this.encoderBlocks.size(); ++i) {
            this.encoderBlocks.get(i).insertModel(encoderBlockModels.get(i));
            this.decoderBlocks.get(i).insertModel(decoderBlockModels.get(i));
        }
        this.firstDecoderBlock.insertModel(transFormerModel.getFirstDecoderBlockModel());
        this.lineBlock.insertModel(transFormerModel.getLineBlockModel());
    }

    public TransFormerManager(TfConfig tfConfig) throws Exception {
        CodecBlock lastEnCoderBlock;
        int multiNumber = tfConfig.getMultiNumber();
        this.maxLength = tfConfig.getMaxLength();
        this.selfTimeCode = tfConfig.isSelfTimeCode();
        int featureDimension = tfConfig.getFeatureDimension();
        if (featureDimension % 2 != 0) {
            throw new Exception("TransFormer \u8bcd\u5411\u91cf\u7ef4\u5ea6\u5fc5\u987b\u4e3a\u5076\u6570");
        }
        int allDepth = tfConfig.getAllDepth();
        double studyPoint = tfConfig.getStudyPoint();
        int typeNumber = tfConfig.getTypeNumber();
        boolean showLog = tfConfig.isShowLog();
        int regularModel = tfConfig.getRegularModel();
        double regular = tfConfig.getRegular();
        if (multiNumber > 1 && featureDimension > 0 && allDepth > 0 && typeNumber > 1) {
            for (int i = 0; i < allDepth; ++i) {
                CodecBlock encoderBlock = new CodecBlock(multiNumber, featureDimension, studyPoint, i + 1, true, regularModel, regular, this.maxLength, this.selfTimeCode, tfConfig.getCoreNumber());
                this.encoderBlocks.add(encoderBlock);
            }
            lastEnCoderBlock = this.encoderBlocks.get(this.encoderBlocks.size() - 1);
            for (int i = 0; i < allDepth; ++i) {
                CodecBlock decoderBlock = new CodecBlock(multiNumber, featureDimension, studyPoint, i + 2, false, regularModel, regular, this.maxLength, this.selfTimeCode, tfConfig.getCoreNumber());
                decoderBlock.setLastEncoderBlock(lastEnCoderBlock);
                this.decoderBlocks.add(decoderBlock);
            }
        } else {
            throw new Exception("param is null,typeNumber:" + typeNumber + ",featureDimension:" + featureDimension);
        }
        CodecBlock lastDecoderBlock = this.decoderBlocks.get(this.decoderBlocks.size() - 1);
        this.connectCodecBlock(this.encoderBlocks);
        this.connectCodecBlock(this.decoderBlocks);
        this.lineBlock = new LineBlock(typeNumber, featureDimension, studyPoint, lastDecoderBlock, showLog, regularModel, regular, tfConfig.getCoreNumber(), tfConfig.getTimePunValue());
        lastDecoderBlock.setLineBlock(this.lineBlock);
        this.firstDecoderBlock = new FirstDecoderBlock(multiNumber, featureDimension, studyPoint, this.decoderBlocks.get(0), this.maxLength, this.selfTimeCode, tfConfig.getCoreNumber());
        this.firstDecoderBlock.setLastEncoderBlock(lastEnCoderBlock);
        this.decoderBlocks.get(0).setFirstDecoderBlock(this.firstDecoderBlock);
        this.sensoryNerve = new SensoryNerve(this.encoderBlocks.get(0), this.firstDecoderBlock);
    }

    private void connectCodecBlock(List<CodecBlock> codecBlocks) {
        int size = codecBlocks.size();
        for (int i = 0; i < size - 1; ++i) {
            CodecBlock encoderBlock = codecBlocks.get(i);
            CodecBlock beforeBlock = codecBlocks.get(i + 1);
            encoderBlock.setBeforeEncoderBlock(beforeBlock);
            beforeBlock.setAfterEncoderBlock(encoderBlock);
        }
    }
}

