/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.voice;

import java.io.IOException;
import java.io.InputStream;

public class MP3 {
    private static final int[][] Mp3_Sample = new int[][]{{384, 384, 384}, {1152, 1152, 1152}, {1152, 576, 576}};
    private static final int[][] MPeg1ByteRate = new int[][]{{32, 32, 32}, {64, 48, 40}, {96, 56, 48}, {128, 64, 56}, {160, 80, 64}, {192, 96, 80}, {224, 112, 96}, {256, 128, 112}, {288, 160, 128}, {320, 192, 160}, {352, 224, 192}, {384, 256, 224}, {416, 320, 256}, {448, 384, 320}};
    private static final int[][] MPeg2ByteRate = new int[][]{{32, 8}, {48, 16}, {56, 24}, {64, 32}, {80, 40}, {96, 48}, {112, 56}, {128, 64}, {144, 80}, {160, 96}, {176, 112}, {192, 128}, {224, 144}, {256, 160}};
    private static final int[][] SampleFrequency = new int[][]{{44100, 48000, 32000}, {22050, 24000, 16000}, {11025, 12000, 8000}};
    private InputStream stream;
    private int Mpeg_Version;
    private int Layer_Version;
    private int ByteRate;
    private int Frequency;
    private int Padding;
    private int Sample;
    private int[] FrameHeader;

    public MP3(InputStream stream) {
        this.stream = stream;
    }

    public int parserMp3Header() throws IOException {
        this.FrameHeader = new int[3];
        byte[] tempBytes = this.readFull(3);
        if (tempBytes == null) {
            return -1;
        }
        for (int i = 0; i < 3; ++i) {
            this.FrameHeader[i] = tempBytes[i] & 0xFF;
        }
        int TagHeaderSize = 0;
        if (this.FrameHeader[0] == 73 && this.FrameHeader[1] == 68 && this.FrameHeader[2] == 51) {
            byte[] tagHeader = this.readFull(7);
            if (tagHeader == null) {
                return -1;
            }
            int tagHeaderSize = ((tagHeader[3] & 0x7F) << 21) + ((tagHeader[4] & 0x7F) << 14) + ((tagHeader[5] & 0x7F) << 7) + (tagHeader[6] & 0x7F);
            if (!this.skipBytes(tagHeaderSize)) {
                return -1;
            }
            TagHeaderSize = tagHeaderSize + 10;
            tempBytes = this.readFull(3);
            if (tempBytes == null) {
                return -1;
            }
            for (int i = 0; i < 3; ++i) {
                this.FrameHeader[i] = tempBytes[i] & 0xFF;
            }
        }
        if (this.FrameHeader[0] != 255 || this.FrameHeader[1] >> 5 != 7) {
            return -1;
        }
        switch ((this.FrameHeader[1] & 0x18) >> 3) {
            case 0: {
                this.Mpeg_Version = 3;
                break;
            }
            case 2: {
                this.Mpeg_Version = 2;
                break;
            }
            case 3: {
                this.Mpeg_Version = 1;
                break;
            }
            default: {
                return -1;
            }
        }
        switch ((this.FrameHeader[1] & 6) >> 1) {
            case 1: {
                this.Layer_Version = 3;
                break;
            }
            case 2: {
                this.Layer_Version = 2;
                break;
            }
            case 3: {
                this.Layer_Version = 1;
                break;
            }
            default: {
                return -1;
            }
        }
        int index = this.FrameHeader[2] >> 4;
        if (index < 1 || index > 14) {
            return -1;
        }
        --index;
        if (this.Mpeg_Version == 1) {
            switch (this.Layer_Version) {
                case 1: {
                    this.ByteRate = MPeg1ByteRate[index][0];
                    break;
                }
                case 2: {
                    this.ByteRate = MPeg1ByteRate[index][1];
                    break;
                }
                case 3: {
                    this.ByteRate = MPeg1ByteRate[index][2];
                }
            }
        } else {
            switch (this.Layer_Version) {
                case 1: {
                    this.ByteRate = MPeg2ByteRate[index][0];
                    break;
                }
                case 2: 
                case 3: {
                    this.ByteRate = MPeg2ByteRate[index][1];
                }
            }
        }
        this.Frequency = SampleFrequency[this.Mpeg_Version - 1][(this.FrameHeader[2] & 0xC) >> 2];
        this.Padding = (this.FrameHeader[2] & 2) >> 1;
        this.Sample = Mp3_Sample[this.Layer_Version - 1][this.Mpeg_Version - 1];
        return TagHeaderSize;
    }

    public long SkipFrame(long num) throws IOException {
        long skipped = 0L;
        byte[] temp = null;
        int i = 0;
        while ((long)i < num) {
            temp = this.ParserFrame();
            if (temp == null) {
                return skipped;
            }
            skipped += (long)temp.length;
            ++i;
        }
        return skipped;
    }

    public byte[] ParserFrame() throws IOException {
        byte[] byteFrameHeader;
        int index = 0;
        if (this.FrameHeader == null) {
            byteFrameHeader = this.readFull(3);
            if (byteFrameHeader == null || byteFrameHeader.length < 3 || (byteFrameHeader[0] & 0xFF) == 84 && (byteFrameHeader[1] & 0xFF) == 65 && (byteFrameHeader[2] & 0xFF) == 71) {
                return null;
            }
            if ((byteFrameHeader[0] & 0xFF) != 255 || (byteFrameHeader[1] & 0xFF) >> 5 != 7) {
                System.out.println("\u8be5MP3\u6587\u4ef6\u975e\u6cd5.");
                return null;
            }
            index = (byteFrameHeader[2] & 0xFF) >> 4;
            this.Padding = (byteFrameHeader[2] & 2) >> 1;
        } else {
            if (this.FrameHeader == null || this.FrameHeader.length < 3 || this.FrameHeader[0] == 84 && this.FrameHeader[1] == 65 && this.FrameHeader[2] == 71) {
                return null;
            }
            index = this.FrameHeader[2] >> 4;
            byteFrameHeader = new byte[3];
            byteFrameHeader[0] = (byte)this.FrameHeader[0];
            byteFrameHeader[0] = (byte)this.FrameHeader[1];
            byteFrameHeader[0] = (byte)this.FrameHeader[2];
            this.FrameHeader = null;
        }
        if (index < 1 || index > 14) {
            return null;
        }
        --index;
        if (this.Mpeg_Version == 1) {
            switch (this.Layer_Version) {
                case 1: {
                    this.ByteRate = MPeg1ByteRate[index][0];
                    break;
                }
                case 2: {
                    this.ByteRate = MPeg1ByteRate[index][1];
                    break;
                }
                case 3: {
                    this.ByteRate = MPeg1ByteRate[index][2];
                }
            }
        } else {
            switch (this.Layer_Version) {
                case 1: {
                    this.ByteRate = MPeg2ByteRate[index][0];
                    break;
                }
                case 2: 
                case 3: {
                    this.ByteRate = MPeg2ByteRate[index][1];
                }
            }
        }
        int frameSize = this.Sample / 8 * this.ByteRate * 1000 / this.Frequency + this.Padding;
        byte[] temp = this.readFull(frameSize - 3);
        if (temp == null) {
            return null;
        }
        byte[] data = new byte[frameSize];
        System.arraycopy(byteFrameHeader, 0, data, 0, 3);
        System.arraycopy(temp, 0, data, 3, temp.length);
        return data;
    }

    public byte[] readFull(int size) throws IOException {
        int n;
        int k;
        byte[] data = new byte[size];
        for (n = 0; n < size && (k = this.stream.read(data, n, size - n)) >= 0; n += k) {
        }
        if (n <= 0) {
            return null;
        }
        if (n < size) {
            byte[] temp = new byte[n];
            System.arraycopy(data, 0, temp, 0, n);
            data = null;
            return temp;
        }
        return data;
    }

    public boolean skipBytes(long skipLength) throws IOException {
        long n;
        for (long k = 0L; k < skipLength; k += n) {
            n = this.stream.skip(skipLength - k);
            if (n >= 0L) continue;
            return false;
        }
        return true;
    }
}

