/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.naturalLanguage;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wlld.naturalLanguage.Tokenizer;
import org.wlld.naturalLanguage.WordTemple;

public class TemplateReader {
    private Map<Integer, List<String>> model = new HashMap<Integer, List<String>>();
    private String charsetName;

    public void read(String url, String charsetName, WordTemple wordTemple) throws Exception {
        int i;
        this.charsetName = charsetName;
        File file = new File(url);
        FileInputStream is = new FileInputStream(file);
        LinkedList<Byte> span = new LinkedList<Byte>();
        int hang = 0;
        int again = 0;
        int upNub = 0;
        boolean isSymbol = false;
        while ((i = ((InputStream)is).read()) > -1) {
            if (i == 35) {
                isSymbol = true;
                continue;
            }
            if (i == 10 || i == 13) {
                isSymbol = false;
                if ((again = again << 1 | 1) == 1) {
                    List<String> lr = this.model.get(upNub);
                    if (lr != null) {
                        lr.add(this.LinkToString(span));
                    } else {
                        ArrayList<String> lis = new ArrayList<String>();
                        lis.add(this.LinkToString(span));
                        this.model.put(upNub, lis);
                    }
                    upNub = 0;
                    ++hang;
                }
                again = 0;
                continue;
            }
            if (isSymbol) {
                int type = i;
                if (type < 48 || type > 57) continue;
                type -= 48;
                if (upNub == 0) {
                    upNub = type;
                    continue;
                }
                upNub = upNub * 10 + type;
                continue;
            }
            span.add((byte)i);
        }
        this.word(wordTemple);
    }

    public void word(WordTemple wordTemple) throws Exception {
        Tokenizer tokenizer = new Tokenizer(wordTemple);
        tokenizer.start(this.model);
    }

    public String LinkToString(LinkedList<Byte> mod) throws UnsupportedEncodingException {
        int b = mod.size();
        byte[] be = new byte[b];
        for (int i = 0; i < b; ++i) {
            be[i] = mod.poll();
        }
        return new String(be, this.charsetName);
    }
}

