/*
 * Decompiled with CFR 0.152.
 */
package org.wlld.transFormer.nerve;

import java.util.List;
import org.wlld.i.ActiveFunction;
import org.wlld.i.OutBack;
import org.wlld.matrixTools.Matrix;
import org.wlld.transFormer.LineBlock;
import org.wlld.transFormer.nerve.Nerve;

public class HiddenNerve
extends Nerve {
    public HiddenNerve(int id, int depth, double studyPoint, ActiveFunction activeFunction, int sensoryNerveNub, int outNerveNub, LineBlock lineBlock, int regularModel, double regular, int coreNumber) throws Exception {
        super(id, "HiddenNerve", studyPoint, activeFunction, sensoryNerveNub, 0, outNerveNub, lineBlock, regularModel, regular, coreNumber);
        this.depth = depth;
    }

    public void receiveErrorMatrix(Matrix g, long eventId, Matrix allError) throws Exception {
        this.updatePower(eventId, g, allError);
    }

    public void receive(Matrix feature, long eventId, boolean isStudy, OutBack outBack, List<Integer> E, Matrix encoderFeature) throws Exception {
        Matrix out = this.opMatrix(feature, isStudy);
        this.sendMessage(eventId, out, isStudy, feature, outBack, E, encoderFeature);
    }

    @Override
    protected void input(long eventId, Matrix parameter, boolean isStudy, Matrix allFeature, OutBack outBack, List<Integer> E, Matrix encoderFeature) throws Exception {
        boolean allReady = this.insertMatrixParameter(eventId, parameter);
        if (allReady) {
            Matrix out = this.opMatrix((Matrix)this.reMatrixFeatures.get(eventId), isStudy);
            this.reMatrixFeatures.remove(eventId);
            this.beforeLayNorm.addNormFromNerve(eventId, isStudy, out, allFeature, outBack, E, encoderFeature);
        }
    }

    public void postMessage(long eventId, Matrix feature, boolean isStudy, OutBack outBack, List<Integer> E) throws Exception {
        Matrix out = this.opMatrix(feature, isStudy);
        this.sendOutMessage(eventId, out, isStudy, outBack, E);
    }
}

