/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.springboot.hotssl.tomcat;

import cn.mzhong.springboot.hotssl.util.KeyStoreLoader;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.springframework.beans.factory.annotation.Value;

public class DefaultX509TrustManager
implements X509TrustManager {
    @Value(value="${server.ssl.trust-store}")
    private String trustStore;
    @Value(value="${server.ssl.trust-store-password}")
    private String trustStorePassword = "";
    @Value(value="${server.ssl.trust-store-type:JKS}")
    private String trustStoreType;

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        KeyStore keyStore = KeyStoreLoader.load(this.trustStore, this.trustStorePassword, this.trustStoreType);
        for (X509Certificate x509Certificate : x509Certificates) {
            try {
                if (keyStore.getCertificateAlias(x509Certificate) == null) continue;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new CertificateException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

