/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.consumer;

import cn.mzhong.janytask.core.TaskAnnotationHandler;
import cn.mzhong.janytask.core.TaskComponentInitializer;
import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.executor.TaskExecutor;
import cn.mzhong.janytask.executor.TaskExecutorService;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskConsumerInitializer
implements TaskComponentInitializer {
    static final Logger Log = LoggerFactory.getLogger(TaskConsumerInitializer.class);
    protected TaskContext context;

    private static <A extends Annotation> QueueInfo<A> findQueueInfo(Object consumer, Class<?> consumerClass, Method method, Class<A> annotationType) {
        Set<Class<?>> interfaces = ClassUtils.getInterfaces(consumerClass);
        QueueInfo<A> queueInfo = null;
        for (Class<?> _interface : interfaces) {
            try {
                A annotation;
                Method pMethod = _interface.getMethod(method.getName(), method.getParameterTypes());
                if (pMethod == null || (annotation = pMethod.getAnnotation(annotationType)) == null) continue;
                queueInfo = new QueueInfo<A>(annotation, _interface, pMethod, consumer, consumerClass, method);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return queueInfo;
    }

    protected <A extends Annotation> List<TaskExecutor<A>> handleConsumer(TaskContext context, Object consumer, Class<?> consumerClass) {
        ArrayList<TaskExecutor<A>> taskList = new ArrayList<TaskExecutor<A>>();
        for (Method method : consumerClass.getMethods()) {
            for (TaskAnnotationHandler annotationProcessor : context.getAnnotationHandlers()) {
                QueueInfo queueInfo = TaskConsumerInitializer.findQueueInfo(consumer, consumerClass, method, annotationProcessor.getAnnotationClass());
                if (queueInfo == null) continue;
                queueInfo.setMessageDao(context.getQueueProvider().createMessageDao(queueInfo));
                taskList.add(annotationProcessor.handleConsumer(context, queueInfo));
                if (!Log.isDebugEnabled()) continue;
                Log.debug("consumer:'" + queueInfo.ID() + "'inited.");
            }
        }
        return taskList;
    }

    protected Object createConsumer(Class<?> consumerClass) {
        try {
            return consumerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<TaskExecutor<? extends Annotation>> createTaskList(TaskContext context) {
        ArrayList<TaskExecutor<? extends Annotation>> taskList = new ArrayList<TaskExecutor<? extends Annotation>>();
        Map<Class<?>, Object> consumerMap = context.getConsumerMap();
        try {
            for (Class<?> consumerClass : context.getConsumerClassSet()) {
                Object consumer = this.createConsumer(consumerClass);
                consumerMap.put(consumerClass, consumer);
                taskList.addAll(this.handleConsumer(context, consumer, consumerClass));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return taskList;
    }

    protected void runTaskExecutors(TaskContext context, List<TaskExecutor<? extends Annotation>> taskList) {
        int nThreads = taskList.size();
        TaskExecutorService taskExecutorService = new TaskExecutorService(nThreads);
        context.setConsumerExecutorService(taskExecutorService);
        for (int i = 0; i < nThreads; ++i) {
            taskExecutorService.execute(taskList.get(i));
        }
    }

    @Override
    public void init(TaskContext context) {
        this.runTaskExecutors(context, this.createTaskList(context));
    }
}

