/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.core;

import cn.mzhong.janytask.config.ApplicationConfig;
import cn.mzhong.janytask.config.QueueConfig;
import cn.mzhong.janytask.consumer.Consumer;
import cn.mzhong.janytask.consumer.TaskConsumerInitializer;
import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.core.TaskInitExcepition;
import cn.mzhong.janytask.core.TaskShutdownHook;
import cn.mzhong.janytask.loopline.LoopLineAnnotationHandler;
import cn.mzhong.janytask.pipleline.PipleLineAnnotationHandler;
import cn.mzhong.janytask.producer.Producer;
import cn.mzhong.janytask.producer.TaskNotFoundException;
import cn.mzhong.janytask.producer.TaskProducerInitializer;
import cn.mzhong.janytask.queue.JdkDataSerializer;
import cn.mzhong.janytask.util.ClassUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskApplication
extends TaskContext {
    static final Logger Log = LoggerFactory.getLogger(TaskApplication.class);

    protected void wellcome() {
        Log.debug(this.applicationConfig.toString());
        Log.debug(this.queueConfig.toString());
        Log.debug("janytask application started!");
    }

    public void init() {
        if (this.applicationConfig == null) {
            this.applicationConfig = new ApplicationConfig();
        }
        if (this.queueConfig == null) {
            this.queueConfig = new QueueConfig();
        }
        if (this.queueProvider == null) {
            throw new TaskInitExcepition("queueProvider\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6307\u5b9aqueueProvider");
        }
        if (this.dataSerializer == null) {
            this.dataSerializer = new JdkDataSerializer();
        }
        if (this.producerInitializer == null) {
            this.producerInitializer = new TaskProducerInitializer();
        }
        if (this.consumerInitializer == null) {
            this.consumerInitializer = new TaskConsumerInitializer();
        }
        this.addAnnotationHandler(new PipleLineAnnotationHandler());
        this.addAnnotationHandler(new LoopLineAnnotationHandler());
        this.setDataSerializer(this.dataSerializer);
        this.setConsumerClassSet(ClassUtils.scanByAnnotation(this.applicationConfig.getBasePackage(), Consumer.class));
        this.setProducerClassSet(ClassUtils.scanByAnnotation(this.applicationConfig.getBasePackage(), Producer.class));
        this.queueProvider.init(this);
        this.producerInitializer.init(this);
        this.consumerInitializer.init(this);
        Runtime.getRuntime().addShutdownHook(new TaskShutdownHook(this));
        this.wellcome();
    }

    public <T> T getProducer(Class<T> producerClass) {
        Object producer = this.producerMap.get(producerClass);
        if (producer == null) {
            for (Map.Entry entry : this.producerMap.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(producerClass)) continue;
                return (T)entry.getValue();
            }
            throw new TaskNotFoundException("\u672a\u5728\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u627e\u5230\u751f\u4ea7\u8005\uff1a" + producerClass.getName());
        }
        return (T)producer;
    }
}

