/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.core;

import cn.mzhong.janytask.core.TaskContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskShutdownHookExecutor
implements Runnable {
    static final Logger Log = LoggerFactory.getLogger(TaskShutdownHookExecutor.class);
    TaskContext context;
    ExecutorService executorService;

    public TaskShutdownHookExecutor(TaskContext context) {
        this.context = context;
        this.executorService = context.getConsumerExecutorService();
    }

    public void run() {
        Log.debug("janytask\u5e94\u7528\u7a0b\u5e8f\u6b63\u5728\u7ec8\u7ed3...");
        this.context.setShutdown(true);
        this.executorService.shutdown();
        try {
            if (this.executorService.awaitTermination(1000L, TimeUnit.SECONDS)) {
                Log.debug("janytask\u5e94\u7528\u7a0b\u5e8f\u5df2\u7ec8\u7ed3\uff0c\u62dc\u62dc!");
                return;
            }
        }
        catch (InterruptedException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
        }
        Log.debug("janytask\u5e94\u7528\u7a0b\u5e8f\u53ef\u80fd\u672a\u6b63\u5e38\u7ec8\u7ed3!");
    }
}

