/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.executor;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.util.ThreadUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskExecutor<A extends Annotation>
implements Runnable {
    static final Logger Log = LoggerFactory.getLogger(TaskExecutor.class);
    protected String ID;
    protected QueueInfo<A> queueInfo;
    protected TaskContext context;
    protected MessageDao messageDao;
    protected Method method;
    protected Object consumer;
    protected long idleInterval;
    protected long sleepInterval;
    protected long cnt = 0L;

    public TaskExecutor(TaskContext context, QueueInfo<A> queueInfo) {
        this.context = context;
        this.queueInfo = queueInfo;
        this.messageDao = queueInfo.getMessageDao();
        this.ID = this.messageDao.ID();
        this.method = queueInfo.getConsumerMethod();
        this.consumer = queueInfo.getConsumer();
        this.idleInterval = context.getQueueConfig().getIdleInterval();
        this.sleepInterval = context.getQueueConfig().getSleepInterval();
    }

    protected abstract void invoke(Message var1);

    protected void invoke() {
        Message message;
        long done;
        long length = this.messageDao.length();
        long startTimeMillis = 0L;
        if (Log.isDebugEnabled()) {
            Log.debug("'{}'\uff1a\u7b2c{}\u8f6e\u6d88\u606f\u5904\u7406\u5f00\u59cb, \u672c\u6b21\u76ee\u6807\u957f\u5ea6:{}", new Object[]{this.ID, this.cnt, length});
            startTimeMillis = System.currentTimeMillis();
        }
        for (done = 0L; done < length && !this.context.isShutdown() && (message = this.messageDao.poll()) != null; ++done) {
            this.invoke(message);
        }
        int spendTime = (int)(System.currentTimeMillis() - startTimeMillis);
        if (Log.isDebugEnabled()) {
            int speed = 0;
            float time = spendTime + 1;
            int seconds = Math.round(time / 1000.0f);
            if (done > 0L) {
                speed = (int)(time / (float)done);
            }
            Log.debug("'{}'\uff1a\u7b2c{}\u8f6e\u6d88\u606f\u5904\u7406\u5b8c\u6bd5\uff0c\u6570\u91cf:{}\uff0c\u603b\u8017\u65f6:{}\u79d2\uff0c\u5355\u6761\u8017\u65f6:{}\u6beb\u79d2", new Object[]{this.ID, this.cnt, done, seconds, speed});
        }
        if ((long)spendTime < this.idleInterval) {
            ThreadUtils.sleep(this.idleInterval - (long)spendTime);
        }
    }

    @Override
    public void run() {
        while (true) {
            ++this.cnt;
            if (this.context.isShutdown()) break;
            try {
                this.invoke();
            }
            catch (Exception e) {
                Log.error(e.getLocalizedMessage(), (Throwable)e);
                ThreadUtils.sleep(15000L);
            }
        }
    }
}

