/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.jdbc;

import cn.mzhong.janytask.tool.PRInvoker;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceHelper {
    protected DataSource dataSource;

    public DataSourceHelper(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected void loadParameters(PreparedStatement statement, Object[] parameters) throws SQLException {
        for (int i = 0; i < parameters.length; ++i) {
            statement.setObject(i + 1, parameters[i]);
        }
    }

    public <T> T openConnection(PRInvoker<Connection, T> invoker) {
        T t;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            t = invoker.invoke(connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return t;
    }

    public <T> T createStatement(final String sql, final PRInvoker<PreparedStatement, T> invoker) {
        return this.openConnection(new PRInvoker<Connection, T>(){

            @Override
            public T invoke(Connection connection) throws Exception {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    Object r = invoker.invoke(statement);
                    return r;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    statement.close();
                }
            }
        });
    }

    public <T> T query(String sql, final Object[] parameters, final PRInvoker<ResultSet, T> invoker) {
        return this.createStatement(sql, new PRInvoker<PreparedStatement, T>(){

            @Override
            public T invoke(PreparedStatement statement) throws Exception {
                DataSourceHelper.this.loadParameters(statement, parameters);
                ResultSet resultSet = statement.executeQuery();
                try {
                    if (resultSet.next()) {
                        Object r = invoker.invoke(resultSet);
                        return r;
                    }
                    Object t = null;
                    return t;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    resultSet.close();
                }
            }
        });
    }

    public <T> LinkedList<T> queryList(String sql, final Object[] parameters, final PRInvoker<ResultSet, T> invoker) {
        return (LinkedList)this.createStatement(sql, new PRInvoker<PreparedStatement, LinkedList<T>>(){

            @Override
            public LinkedList<T> invoke(PreparedStatement statement) throws Exception {
                DataSourceHelper.this.loadParameters(statement, parameters);
                ResultSet resultSet = statement.executeQuery();
                LinkedList list = new LinkedList();
                try {
                    while (resultSet.next()) {
                        list.add(invoker.invoke(resultSet));
                    }
                    return list;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public boolean execute(String sql, final Object ... parameters) {
        return this.createStatement(sql, new PRInvoker<PreparedStatement, Boolean>(){

            @Override
            public Boolean invoke(PreparedStatement statement) throws Exception {
                DataSourceHelper.this.loadParameters(statement, parameters);
                return statement.execute();
            }
        });
    }

    public long queryLong(String sql, Object[] parameters) {
        Long resultInt = this.query(sql, parameters, new PRInvoker<ResultSet, Long>(){

            @Override
            public Long invoke(ResultSet resultSet) throws Exception {
                return resultSet.getLong(1);
            }
        });
        return resultInt == null ? 0L : resultInt;
    }

    public String queryString(String sql, Object[] parameters) {
        return this.query(sql, parameters, new PRInvoker<ResultSet, String>(){

            @Override
            public String invoke(ResultSet resultSet) throws Exception {
                return resultSet.getString(1);
            }
        });
    }

    public int update(String sql, final Object ... parameters) {
        return this.createStatement(sql, new PRInvoker<PreparedStatement, Integer>(){

            @Override
            public Integer invoke(PreparedStatement statement) throws Exception {
                DataSourceHelper.this.loadParameters(statement, parameters);
                return statement.executeUpdate();
            }
        });
    }
}

