/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.jdbc;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.jdbc.BytesMessage;
import cn.mzhong.janytask.jdbc.mapper.MessageMapper;
import cn.mzhong.janytask.queue.LockedMessageDao;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.QueueInfo;
import java.util.Date;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcMessageDao
extends LockedMessageDao {
    protected TaskContext context;
    protected MessageMapper messageMapper;

    public JdbcMessageDao(TaskContext context, MessageMapper messageMapper, QueueInfo lineInfo) {
        super(context, lineInfo);
        this.messageMapper = messageMapper;
    }

    @Override
    public void push(Message message) {
        BytesMessage jdbcMessage = new BytesMessage(message);
        jdbcMessage.setContentBytes(this.dataSerializer.serialize(message.getContent()));
        jdbcMessage.setPushTime(new Date());
        jdbcMessage.setQueueId(this.ID);
        this.messageMapper.save(jdbcMessage);
    }

    @Override
    public void done(Message message) {
        BytesMessage jdbcMessage = new BytesMessage(message);
        jdbcMessage.setDoneTime(new Date());
        this.messageMapper.done(jdbcMessage);
    }

    @Override
    public void error(Message message) {
        BytesMessage jdbcMessage = new BytesMessage(message);
        jdbcMessage.setErrorTime(new Date());
        this.messageMapper.error(jdbcMessage);
    }

    @Override
    public long length() {
        return this.messageMapper.length(this.ID);
    }

    @Override
    protected LinkedList<String> queueIdList() {
        return this.messageMapper.keys();
    }

    @Override
    protected Message get(String id) {
        BytesMessage jdbcMessage = this.messageMapper.get(id);
        Object[] content = (Object[])this.dataSerializer.deserialize(jdbcMessage.getContentBytes());
        jdbcMessage.setContent(content);
        return jdbcMessage;
    }

    @Override
    protected boolean lock(String id) {
        return this.messageMapper.lock(id);
    }

    @Override
    protected boolean unLock(String id) {
        return this.messageMapper.unLock(id);
    }
}

