/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.jdbc;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.jdbc.DataSourceHelper;
import cn.mzhong.janytask.jdbc.DriverType;
import cn.mzhong.janytask.jdbc.JdbcMessageDao;
import cn.mzhong.janytask.jdbc.mapper.MessageMapper;
import cn.mzhong.janytask.jdbc.mapper.MysqlMessageMapper;
import cn.mzhong.janytask.jdbc.mapper.OracleMessageMapper;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.queue.QueueProvider;
import cn.mzhong.janytask.tool.PRInvoker;
import cn.mzhong.janytask.util.Assert;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProvider
implements QueueProvider {
    static final Logger Log = LoggerFactory.getLogger(JdbcProvider.class);
    protected DataSource dataSource;
    protected String table = "JANYTASK_MESSAGE";
    protected DataSourceHelper dataSourceHelper;
    protected MessageMapper messageMapper;
    protected TaskContext context;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public MessageDao createMessageDao(QueueInfo queueInfo) {
        return new JdbcMessageDao(this.context, this.messageMapper, queueInfo);
    }

    protected String getDriverName() {
        return this.dataSourceHelper.openConnection(new PRInvoker<Connection, String>(){

            @Override
            public String invoke(Connection connection) throws Exception {
                return connection.getMetaData().getDriverName();
            }
        });
    }

    protected DriverType getDriverType(String driverName) {
        Assert.notNull(driverName, "\u53c2\u6570driverName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String trimedAndUpperedDriverName = driverName.toUpperCase().trim();
        for (DriverType type : DriverType.values()) {
            if (!trimedAndUpperedDriverName.contains(type.name())) continue;
            return type;
        }
        return DriverType.UNKNOWN;
    }

    public void init(TaskContext context) {
        this.context = context;
        this.table = this.table.toUpperCase();
        this.dataSourceHelper = new DataSourceHelper(this.dataSource);
        if (Log.isDebugEnabled()) {
            Log.debug(this.toString());
        }
        String driverName = this.getDriverName();
        DriverType driverType = this.getDriverType(driverName);
        switch (driverType) {
            case MYSQL: {
                Log.debug("\u6570\u636e\u5e93\u7c7b\u578b\uff1aMysql");
                this.messageMapper = new MysqlMessageMapper(this.context, this.dataSourceHelper, this.table);
                break;
            }
            case ORACLE: {
                Log.debug("\u6570\u636e\u5e93\u7c7b\u578b\uff1aOracle");
                this.messageMapper = new OracleMessageMapper(this.context, this.dataSourceHelper, this.table);
                break;
            }
            default: {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + driverName);
            }
        }
        this.messageMapper.init();
    }

    public String toString() {
        return "JdbcProvider{dataSource=" + this.dataSource + ", table='" + this.table + '\'' + '}';
    }
}

