/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.loopline;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.executor.TaskExecutor;
import cn.mzhong.janytask.loopline.LoopLineAnnotationHandler;
import cn.mzhong.janytask.loopline.Loopline;
import cn.mzhong.janytask.queue.Message;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.util.ValueUtils;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LooplineTaskExecutor
extends TaskExecutor<Loopline> {
    Logger Log = LoggerFactory.getLogger(LoopLineAnnotationHandler.class);
    Loopline loopline;

    public LooplineTaskExecutor(TaskContext context, QueueInfo<Loopline> queueInfo) {
        super(context, queueInfo);
        this.loopline = queueInfo.getAnnotation();
        this.idleInterval = ValueUtils.uLong(this.loopline.idleInterval(), this.idleInterval);
        this.sleepInterval = ValueUtils.uLong(this.loopline.sleepInterval(), this.sleepInterval);
    }

    @Override
    protected void invoke(Message message) {
        Object consumer = this.queueInfo.getConsumer();
        Method method = this.queueInfo.getConsumerMethod();
        MessageDao messageDao = this.queueInfo.getMessageDao();
        try {
            Boolean result = (Boolean)method.invoke(consumer, message.getContent());
            if (result != null && result.booleanValue()) {
                messageDao.done(message);
            } else {
                messageDao.back(message);
            }
        }
        catch (Exception e) {
            this.Log.error(e.getLocalizedMessage(), (Throwable)e);
            message.setThrowable(e);
            messageDao.error(message);
        }
    }
}

