/*
 * Decompiled with CFR 0.152.
 */
package cn.mzhong.janytask.mongo;

import cn.mzhong.janytask.core.TaskContext;
import cn.mzhong.janytask.mongo.MongoDbMessageDao;
import cn.mzhong.janytask.queue.MessageDao;
import cn.mzhong.janytask.queue.QueueInfo;
import cn.mzhong.janytask.queue.QueueProvider;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;

public class MongoDBProvider
implements QueueProvider {
    protected String host;
    protected int port;
    protected String username;
    protected String database;
    protected String password;
    protected MongoDatabase mongoDatabase;
    protected TaskContext context;

    public MessageDao createMessageDao(QueueInfo queueInfo) {
        return new MongoDbMessageDao(this.context, queueInfo, this.mongoDatabase.getCollection(queueInfo.ID()));
    }

    public void init(TaskContext context) {
        this.context = context;
        ServerAddress serverAddress = new ServerAddress(this.host, this.port);
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)this.username, (String)this.database, (char[])this.password.toCharArray());
        ArrayList<ServerAddress> addressList = new ArrayList<ServerAddress>();
        addressList.add(serverAddress);
        ArrayList<MongoCredential> credentialList = new ArrayList<MongoCredential>();
        credentialList.add(credential);
        MongoClient mongoClient = new MongoClient(addressList, credentialList);
        this.mongoDatabase = mongoClient.getDatabase(this.database);
    }
}

